/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.discovery.core.model;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoverySource;

public class JarDiscoverySource
extends AbstractDiscoverySource {
    private final String id;
    private final File jarFile;

    public JarDiscoverySource(String id, File jarFile) {
        this.id = id;
        this.jarFile = jarFile;
    }

    public Object getId() {
        return this.id;
    }

    public URL getResource(String resourceName) {
        try {
            String prefix = this.jarFile.toURI().toURL().toExternalForm();
            return new URL("jar:" + prefix + "!/" + URLEncoder.encode(resourceName, "utf-8"));
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }
}

