/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.discovery.tests.core.mock.MockBundleDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCertification;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.Policy;

public class BundleDiscoveryStrategyTest
extends TestCase {
    private MockBundleDiscoveryStrategy discoveryStrategy;
    private final List<DiscoveryCategory> categories = new ArrayList<DiscoveryCategory>();
    private final List<DiscoveryConnector> connectors = new ArrayList<DiscoveryConnector>();
    private final List<DiscoveryCertification> certifications = new ArrayList<DiscoveryCertification>();

    protected void setUp() throws Exception {
        super.setUp();
        this.discoveryStrategy = new MockBundleDiscoveryStrategy();
        this.discoveryStrategy.setPolicy(new Policy(true));
        this.discoveryStrategy.setCategories(this.categories);
        this.discoveryStrategy.setConnectors(this.connectors);
        this.discoveryStrategy.setCertifications(this.certifications);
    }

    public void testDiscovery() throws CoreException {
        this.discoveryStrategy.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        BundleDiscoveryStrategyTest.assertFalse((boolean)this.categories.isEmpty());
        BundleDiscoveryStrategyTest.assertFalse((boolean)this.connectors.isEmpty());
        DiscoveryCategory category = this.findCategoryById("org.eclipse.mylyn.discovery.tests.connectorCategory1");
        BundleDiscoveryStrategyTest.assertNotNull((Object)category);
        DiscoveryConnector connector = this.findConnectorById("org.eclipse.mylyn.discovery.tests.connectorDescriptor1");
        BundleDiscoveryStrategyTest.assertNotNull((Object)connector);
        DiscoveryCertification certification = this.findCertificationById("org.eclipse.mylyn.discovery.tests.certification1");
        BundleDiscoveryStrategyTest.assertNotNull((Object)certification);
    }

    public void testDiscoveryNoCategoriesPolicy() throws CoreException {
        this.discoveryStrategy.setPolicy(new Policy(false));
        this.discoveryStrategy.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        BundleDiscoveryStrategyTest.assertTrue((boolean)this.categories.isEmpty());
    }

    private DiscoveryConnector findConnectorById(String id) {
        for (DiscoveryConnector descriptor : this.connectors) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }

    private DiscoveryCategory findCategoryById(String id) {
        for (DiscoveryCategory descriptor : this.categories) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }

    private DiscoveryCertification findCertificationById(String id) {
        for (DiscoveryCertification descriptor : this.certifications) {
            if (!id.equals(descriptor.getId())) continue;
            return descriptor;
        }
        return null;
    }
}

