/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.mylyn.discovery.tests.DiscoveryTestConstants;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorDiscovery;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.RemoteBundleDiscoveryStrategy;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Bundle;

public class ConnectorDiscoveryRemoteTest
extends TestCase {
    private ConnectorDiscovery connectorDiscovery;

    protected void setUp() throws Exception {
        super.setUp();
        this.connectorDiscovery = new ConnectorDiscovery();
        this.connectorDiscovery.setVerifyUpdateSiteAvailability(false);
        this.connectorDiscovery.getDiscoveryStrategies().clear();
        RemoteBundleDiscoveryStrategy remoteStrategy = new RemoteBundleDiscoveryStrategy();
        remoteStrategy.setDirectoryUrl(DiscoveryTestConstants.DEFAULT_MYLYN_DISCOVERY_URL);
        this.connectorDiscovery.getDiscoveryStrategies().add(remoteStrategy);
    }

    public void testRemoteDirectory() throws CoreException {
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryRemoteTest.assertFalse((boolean)this.connectorDiscovery.getCategories().isEmpty());
        ConnectorDiscoveryRemoteTest.assertFalse((boolean)this.connectorDiscovery.getConnectors().isEmpty());
    }

    public void testVerifyAvailability() throws Exception {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.equinox.p2.engine");
        if (bundle != null && new VersionRange("[1.0.0,1.1.0)").isIncluded(bundle.getVersion())) {
            System.err.println("Skipping test on Eclipse 3.5 due to lack of proxy support");
            return;
        }
        this.connectorDiscovery.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        for (DiscoveryConnector connector : this.connectorDiscovery.getConnectors()) {
            ConnectorDiscoveryRemoteTest.assertNull((Object)connector.getAvailable());
        }
        this.connectorDiscovery.verifySiteAvailability((IProgressMonitor)new NullProgressMonitor());
        ConnectorDiscoveryRemoteTest.assertFalse((boolean)this.connectorDiscovery.getConnectors().isEmpty());
        int unavailableCount = 0;
        for (DiscoveryConnector connector : this.connectorDiscovery.getConnectors()) {
            ConnectorDiscoveryRemoteTest.assertNotNull((String)("Failed to verify availability for " + connector.getId()), (Object)connector.getAvailable());
            if (connector.getAvailable().booleanValue()) continue;
            ++unavailableCount;
        }
        if (unavailableCount > 0) {
            ConnectorDiscoveryRemoteTest.fail((String)String.format("%s unavailable: %s", unavailableCount, this.computeUnavailableConnetorDescriptorNames()));
        }
    }

    private String computeUnavailableConnetorDescriptorNames() {
        String message = "";
        for (DiscoveryConnector connector : this.connectorDiscovery.getConnectors()) {
            if (connector.getAvailable().booleanValue()) continue;
            if (message.length() > 0) {
                message = String.valueOf(message) + ", ";
            }
            message = String.valueOf(message) + connector.getName();
        }
        return message;
    }
}

