/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.eclipse.mylyn.internal.discovery.core.model.Directory;
import org.eclipse.mylyn.internal.discovery.core.model.DirectoryParser;

public class DirectoryParserTest
extends TestCase {
    private DirectoryParser parser;

    protected void setUp() throws Exception {
        super.setUp();
        this.parser = new DirectoryParser();
    }

    public void testParse() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\"/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)1, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((String)"http://foo.bar.nodomain/baz.jar", (String)((Directory.Entry)directory.getEntries().get(0)).getLocation());
    }

    public void testParseBadFormat() throws IOException {
        try {
            this.parser.parse((Reader)new StringReader("<directory2 xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\"/></directory2>"));
            DirectoryParserTest.fail((String)"Expected exception");
        }
        catch (IOException iOException) {}
    }

    public void testParseMalformed() throws IOException {
        try {
            this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\">"));
            DirectoryParserTest.fail((String)"Expected exception");
        }
        catch (IOException iOException) {}
    }

    public void testParseUnexpectedElementsAndAttributes() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\" id=\"asdf\"><baz/></entry><foo/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)1, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((String)"http://foo.bar.nodomain/baz.jar", (String)((Directory.Entry)directory.getEntries().get(0)).getLocation());
    }

    public void testParseNoNS() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory><entry url=\"http://foo.bar.nodomain/baz.jar\"/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)1, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((String)"http://foo.bar.nodomain/baz.jar", (String)((Directory.Entry)directory.getEntries().get(0)).getLocation());
    }

    public void testParsePermitCategoriesTrue() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\" permitCategories=\"true\"/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)1, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((boolean)true, (boolean)((Directory.Entry)directory.getEntries().get(0)).isPermitCategories());
    }

    public void testParsePermitCategoriesFalse() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\" permitCategories=\"false\"/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)1, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((boolean)false, (boolean)((Directory.Entry)directory.getEntries().get(0)).isPermitCategories());
    }

    public void testParsePermitCategoriesNotSpecified() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\"/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)1, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((boolean)false, (boolean)((Directory.Entry)directory.getEntries().get(0)).isPermitCategories());
    }

    public void testParsePermitCategoriesSpecifiedBadly() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\" permitCategories=\"\"/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)1, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((boolean)false, (boolean)((Directory.Entry)directory.getEntries().get(0)).isPermitCategories());
    }

    public void testParsePermitCategoriesSpecifiedBadly2() throws IOException {
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"http://foo.bar.nodomain/baz.jar\" permitCategories=\"asdf\"/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)1, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((boolean)false, (boolean)((Directory.Entry)directory.getEntries().get(0)).isPermitCategories());
    }

    public void testParseBaseRelativeUrl() throws IOException, URISyntaxException {
        this.parser.setBaseUri(new URI("http://base.uri/location/directory.xml"));
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"parent/baz.jar\"/><entry url=\"http://absolute/bar.jar\"/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)2, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((String)"http://base.uri/location/parent/baz.jar", (String)((Directory.Entry)directory.getEntries().get(0)).getLocation());
        DirectoryParserTest.assertEquals((String)"http://absolute/bar.jar", (String)((Directory.Entry)directory.getEntries().get(1)).getLocation());
    }

    public void testParseRootUrl() throws IOException, URISyntaxException {
        this.parser.setBaseUri(new URI("http://base.uri/location/directory.xml"));
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\"/baz.jar\"/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)1, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((String)"http://base.uri/baz.jar", (String)((Directory.Entry)directory.getEntries().get(0)).getLocation());
    }

    public void testParseBaseInvalidRelativeUrl() throws IOException, URISyntaxException {
        this.parser.setBaseUri(new URI("http://base.uri/location/directory.xml"));
        Directory directory = this.parser.parse((Reader)new StringReader("<directory xmlns=\"http://www.eclipse.org/mylyn/discovery/directory/\"><entry url=\":/baz.jar\"/><entry url=\"http://absolute/bar.jar\"/></directory>"));
        DirectoryParserTest.assertNotNull((Object)directory);
        DirectoryParserTest.assertEquals((int)2, (int)directory.getEntries().size());
        DirectoryParserTest.assertEquals((String)":/baz.jar", (String)((Directory.Entry)directory.getEntries().get(0)).getLocation());
        DirectoryParserTest.assertEquals((String)"http://absolute/bar.jar", (String)((Directory.Entry)directory.getEntries().get(1)).getLocation());
    }
}

