/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.sync;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.commons.net.Policy;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.ITasksCoreConstants;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.sync.Messages;
import org.eclipse.mylyn.internal.tasks.core.sync.SynchronizationSession;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.IRepositoryModel;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskContainer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tasks.core.data.TaskRelation;
import org.eclipse.mylyn.tasks.core.sync.SynchronizationJob;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizeTasksJob
extends SynchronizationJob {
    private final AbstractRepositoryConnector connector;
    private final TaskDataManager taskDataManager;
    private final TaskList taskList;
    private final Set<ITask> allTasks;
    private final IRepositoryManager repositoryManager;
    private TaskRepository taskRepository;
    private Map<String, TaskRelation[]> relationsByTaskId;
    private boolean updateRelations;
    private final IRepositoryModel tasksModel;
    private SynchronizationSession session;
    private final List<IStatus> statuses;

    public SynchronizeTasksJob(TaskList taskList, TaskDataManager synchronizationManager, IRepositoryModel tasksModel, AbstractRepositoryConnector connector, TaskRepository taskRepository, Set<ITask> tasks) {
        this(taskList, synchronizationManager, tasksModel, connector, (IRepositoryManager)null, tasks);
        this.taskRepository = taskRepository;
    }

    public SynchronizeTasksJob(TaskList taskList, TaskDataManager synchronizationManager, IRepositoryModel tasksModel, AbstractRepositoryConnector connector, IRepositoryManager repositoryManager, Set<ITask> tasks) {
        super("Synchronizing Tasks (" + tasks.size() + " tasks)");
        this.taskList = taskList;
        this.taskDataManager = synchronizationManager;
        this.tasksModel = tasksModel;
        this.connector = connector;
        this.repositoryManager = repositoryManager;
        this.allTasks = tasks;
        this.statuses = new ArrayList<IStatus>();
        this.setRule(new ITasksCoreConstants.MutexSchedulingRule());
    }

    /*
     * Unable to fully structure code
     */
    public IStatus run(IProgressMonitor jobMonitor) {
        block13: {
            try {
                this.monitor.setCanceled(false);
                this.monitor.attach(jobMonitor);
                try {
                    if (this.taskRepository == null) {
                        try {
                            this.monitor.beginTask(Messages.SynchronizeTasksJob_Processing, this.allTasks.size() * 100);
                            tasksByRepository = new HashMap<TaskRepository, HashSet<ITask>>();
                            for (ITask task : this.allTasks) {
                                repository = this.repositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl());
                                tasks = (HashSet<ITask>)tasksByRepository.get((Object)repository);
                                if (tasks == null) {
                                    tasks = new HashSet<ITask>();
                                    tasksByRepository.put(repository, tasks);
                                }
                                tasks.add(task);
                            }
                            for (TaskRepository taskRepository : tasksByRepository.keySet()) {
                                this.setName(MessageFormat.format(Messages.SynchronizeTasksJob_Synchronizing_Tasks__X_, new Object[]{taskRepository.getRepositoryLabel()}));
                                this.taskRepository = taskRepository;
                                repositoryTasks = (Set)tasksByRepository.get((Object)taskRepository);
                                this.run(repositoryTasks, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)this.monitor, repositoryTasks.size() * 100));
                            }
                            break block13;
                        }
                        finally {
                            this.monitor.done();
                        }
                    }
                    this.run(this.allTasks, (IProgressMonitor)this.monitor);
                    break block13;
                }
                catch (OperationCanceledException v0) {
                    ** for (task : this.allTasks)
                }
lbl-1000:
                // 1 sources

                {
                    ((AbstractTask)task).setSynchronizing(false);
                    this.taskList.notifyElementChanged(task);
                    continue;
                }
lbl36:
                // 1 sources

                var9_10 = Status.CANCEL_STATUS;
                return var9_10;
            }
            finally {
                this.monitor.detach(jobMonitor);
            }
        }
        return Status.OK_STATUS;
    }

    private void run(Set<ITask> tasks, IProgressMonitor monitor) {
        this.relationsByTaskId = new HashMap<String, TaskRelation[]>();
        this.updateRelations = true;
        this.runInternal(tasks, monitor);
        this.synchronizedTaskRelations(monitor, this.relationsByTaskId);
    }

    public void synchronizedTaskRelations(IProgressMonitor monitor, Map<String, TaskRelation[]> relationsByTaskId) {
        this.updateRelations = false;
        for (String taskId : relationsByTaskId.keySet()) {
            TaskRelation[] relations;
            ITask parentTask = this.taskList.getTask(this.taskRepository.getRepositoryUrl(), taskId);
            if (!(parentTask instanceof ITaskContainer)) continue;
            HashSet<ITask> removedChildTasks = new HashSet<ITask>(((ITaskContainer)((Object)parentTask)).getChildren());
            TaskRelation[] taskRelationArray = relations = relationsByTaskId.get(taskId);
            int n = relations.length;
            int n2 = 0;
            while (n2 < n) {
                TaskRelation relation = taskRelationArray[n2];
                if (relation.getDirection() == TaskRelation.Direction.OUTWARD && relation.getKind() == TaskRelation.Kind.CONTAINMENT) {
                    ITask task = this.taskList.getTask(this.taskRepository.getRepositoryUrl(), relation.getTaskId());
                    if (task == null) {
                        try {
                            task = this.synchronizeTask(monitor, relation.getTaskId());
                        }
                        catch (CoreException e) {
                            String taskKey = task != null && task.getTaskKey() != null ? task.getTaskKey() : relation.getTaskId();
                            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", NLS.bind((String)Messages.SynchronizeTasksJob_Synchronization_of_task_ID_REPOSITORY_failed, (Object)taskKey, (Object)this.taskRepository.getRepositoryLabel()), (Throwable)e));
                        }
                    } else {
                        removedChildTasks.remove(task);
                    }
                    if (task != null) {
                        this.taskList.addTask(task, (AbstractTaskContainer)((Object)parentTask));
                    }
                }
                ++n2;
            }
            for (ITask task : removedChildTasks) {
                this.taskList.removeFromContainer((AbstractTaskContainer)((Object)parentTask), task);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void runInternal(Set<ITask> tasks, IProgressMonitor monitor) {
        block15: {
            if (!this.isUser()) {
                monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
            }
            try {
                try {
                    monitor.beginTask(Messages.SynchronizeTasksJob_Processing, tasks.size() * 100);
                    if (this.canGetMultiTaskData(this.taskRepository)) {
                        try {
                            for (ITask task : tasks) {
                                this.resetStatus(task);
                            }
                            this.synchronizeTasks((IProgressMonitor)new SubProgressMonitor(monitor, tasks.size() * 100), this.taskRepository, tasks);
                            break block15;
                        }
                        catch (CoreException e) {
                            ** for (task : tasks)
                        }
lbl-1000:
                        // 1 sources

                        {
                            this.updateStatus(this.taskRepository, task, e.getStatus());
                            continue;
lbl17:
                            // 1 sources

                            break block15;
                        }
                    }
                    for (ITask task : tasks) {
                        Policy.checkCanceled((IProgressMonitor)monitor);
                        this.resetStatus(task);
                        try {
                            this.synchronizeTask((IProgressMonitor)new SubProgressMonitor(monitor, 100), task);
                        }
                        catch (CoreException e) {
                            this.updateStatus(this.taskRepository, task, e.getStatus());
                        }
                    }
                }
                catch (OperationCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Synchronization failed", (Throwable)e));
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private boolean canGetMultiTaskData(TaskRepository taskRepository) {
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        return taskDataHandler != null && taskDataHandler.canGetMultiTaskData(taskRepository);
    }

    private void synchronizeTask(IProgressMonitor monitor, ITask task) throws CoreException {
        String taskId;
        TaskData taskData;
        monitor.subTask(MessageFormat.format(Messages.SynchronizeTasksJob_Receiving_task_X, task.getSummary()));
        this.resetStatus(task);
        if (!this.isUser()) {
            monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
        }
        if ((taskData = this.connector.getTaskData(this.taskRepository, taskId = task.getTaskId(), monitor)) != null) {
            this.updateFromTaskData(this.taskRepository, task, taskData, monitor);
            return;
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Connector failed to return task data for task \"" + task + "\""));
    }

    private ITask synchronizeTask(IProgressMonitor monitor, String taskId) throws CoreException {
        TaskData taskData;
        monitor.subTask(MessageFormat.format(Messages.SynchronizeTasksJob_Receiving_task_X, taskId));
        if (!this.isUser()) {
            monitor = Policy.backgroundMonitorFor((IProgressMonitor)monitor);
        }
        if ((taskData = this.connector.getTaskData(this.taskRepository, taskId, monitor)) != null) {
            return this.createFromTaskData(this.taskRepository, taskId, taskData, monitor);
        }
        throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Connector failed to return task data for task \"" + taskId + "\""));
    }

    private void resetStatus(ITask task) {
        if (((AbstractTask)task).getStatus() != null) {
            ((AbstractTask)task).setStatus(null);
            this.taskList.notifySynchronizationStateChanged(task);
        }
    }

    private void synchronizeTasks(final IProgressMonitor monitor, final TaskRepository repository, Set<ITask> tasks) throws CoreException {
        monitor.subTask(MessageFormat.format(Messages.SynchronizeTasksJob_Receiving_X_tasks_from_X, tasks.size(), repository.getRepositoryLabel()));
        final HashMap<String, ITask> idToTask = new HashMap<String, ITask>();
        for (ITask task : tasks) {
            idToTask.put(task.getTaskId(), task);
        }
        TaskDataCollector collector = new TaskDataCollector(){

            public void accept(TaskData taskData) {
                ITask task = (ITask)idToTask.remove(taskData.getTaskId());
                if (task != null) {
                    SynchronizeTasksJob.this.updateFromTaskData(repository, task, taskData, monitor);
                }
            }

            public void failed(String taskId, IStatus status) {
                ITask task = (ITask)idToTask.get(taskId);
                if (task != null) {
                    SynchronizeTasksJob.this.updateStatus(SynchronizeTasksJob.this.taskRepository, task, status);
                }
            }
        };
        Set<String> taskIds = Collections.unmodifiableSet(new HashSet(idToTask.keySet()));
        this.connector.getTaskDataHandler().getMultiTaskData(repository, taskIds, collector, monitor);
    }

    private void updateFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData, IProgressMonitor monitor) {
        try {
            Collection<TaskRelation> relations;
            this.taskDataManager.putUpdatedTaskData(task, taskData, this.isUser(), this.getSession(), monitor);
            if (this.updateRelations && (relations = this.connector.getTaskRelations(taskData)) != null) {
                this.relationsByTaskId.put(task.getTaskId(), relations.toArray(new TaskRelation[0]));
            }
        }
        catch (CoreException e) {
            this.updateStatus(taskRepository, task, e.getStatus());
        }
    }

    private ITask createFromTaskData(TaskRepository taskRepository, String taskId, TaskData taskData, IProgressMonitor monitor) throws CoreException {
        ITask task = this.tasksModel.createTask(taskRepository, taskData.getTaskId());
        ((AbstractTask)task).setSynchronizationState(ITask.SynchronizationState.INCOMING_NEW);
        this.taskDataManager.putUpdatedTaskData(task, taskData, this.isUser(), this.getSession(), monitor);
        return task;
    }

    private void updateStatus(TaskRepository repository, ITask task, IStatus status) {
        this.statuses.add(status);
        ((AbstractTask)task).setStatus(status);
        if (!this.isUser()) {
            ((AbstractTask)task).setSynchronizing(false);
        }
        this.taskList.notifyElementChanged(task);
    }

    public SynchronizationSession getSession() {
        return this.session;
    }

    public void setSession(SynchronizationSession session) {
        this.session = session;
    }

    public Collection<IStatus> getStatuses() {
        return Collections.unmodifiableCollection(this.statuses);
    }
}

