/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core.data;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelEvent;
import org.eclipse.mylyn.tasks.core.data.TaskDataModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataModel {
    private List<TaskDataModelListener> listeners;
    private final ITask task;
    private final TaskRepository taskRepository;
    private final Set<TaskAttribute> unsavedChangedAttributes;
    private final ITaskDataWorkingCopy workingCopy;

    public TaskDataModel(TaskRepository taskRepository, ITask task, ITaskDataWorkingCopy taskDataState) {
        Assert.isNotNull((Object)((Object)taskRepository));
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)taskDataState);
        this.task = task;
        this.taskRepository = taskRepository;
        this.workingCopy = taskDataState;
        this.unsavedChangedAttributes = new HashSet<TaskAttribute>();
    }

    public void addModelListener(TaskDataModelListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<TaskDataModelListener>();
        }
        this.listeners.add(listener);
    }

    public void attributeChanged(TaskAttribute attribute) {
        if (attribute.getParentAttribute() != this.getTaskData().getRoot()) {
            throw new RuntimeException("Editing is only supported for attributes that are attached to the root of task data");
        }
        this.unsavedChangedAttributes.add(attribute);
        if (this.listeners != null) {
            TaskDataModelListener[] listeners;
            final TaskDataModelEvent event = new TaskDataModelEvent(this, TaskDataModelEvent.EventKind.CHANGED, attribute);
            TaskDataModelListener[] taskDataModelListenerArray = listeners = this.listeners.toArray(new TaskDataModelListener[0]);
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                final TaskDataModelListener listener = taskDataModelListenerArray[n2];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Listener failed", e));
                    }

                    public void run() throws Exception {
                        listener.attributeChanged(event);
                    }
                });
                ++n2;
            }
        }
    }

    public TaskAttribute getLastReadAttribute(TaskAttribute taskAttribute) {
        TaskData lastReadData = this.workingCopy.getLastReadData();
        if (lastReadData == null) {
            return null;
        }
        return lastReadData.getRoot().getMappedAttribute(taskAttribute.getPath());
    }

    public Set<TaskAttribute> getChangedAttributes() {
        LinkedHashSet<TaskAttribute> changedAttributes = new LinkedHashSet<TaskAttribute>();
        changedAttributes.addAll(this.workingCopy.getEditsData().getRoot().getAttributes().values());
        changedAttributes.addAll(this.unsavedChangedAttributes);
        return changedAttributes;
    }

    public Set<TaskAttribute> getChangedOldAttributes() {
        Set<TaskAttribute> newChangedAttributes = this.getChangedAttributes();
        LinkedHashSet<TaskAttribute> oldAttributes = new LinkedHashSet<TaskAttribute>();
        TaskData repositoryReadData = this.workingCopy.getRepositoryData();
        if (repositoryReadData != null) {
            for (TaskAttribute taskAttribute : newChangedAttributes) {
                TaskAttribute attOld = repositoryReadData.getRoot().getAttribute(taskAttribute.getId());
                if (attOld == null) continue;
                oldAttributes.add(attOld);
            }
        }
        return oldAttributes;
    }

    public ITask getTask() {
        return this.task;
    }

    public TaskData getTaskData() {
        return this.workingCopy.getLocalData();
    }

    public TaskRepository getTaskRepository() {
        return this.taskRepository;
    }

    public boolean hasBeenRead() {
        return this.workingCopy.getLastReadData() != null;
    }

    public boolean hasIncomingChanges(TaskAttribute taskAttribute) {
        TaskData lastReadData = this.workingCopy.getLastReadData();
        if (lastReadData == null) {
            return true;
        }
        if (this.hasOutgoingChanges(taskAttribute)) {
            return false;
        }
        TaskAttribute oldAttribute = lastReadData.getRoot().getMappedAttribute(taskAttribute.getPath());
        if (oldAttribute == null) {
            return true;
        }
        return !this.getTaskData().getAttributeMapper().equals(taskAttribute, oldAttribute);
    }

    public boolean hasOutgoingChanges(TaskAttribute taskAttribute) {
        return this.workingCopy.getEditsData().getRoot().getMappedAttribute(taskAttribute.getPath()) != null;
    }

    public boolean isDirty() {
        return this.unsavedChangedAttributes.size() > 0 || !this.workingCopy.isSaved();
    }

    public void refresh(IProgressMonitor monitor) throws CoreException {
        this.workingCopy.refresh(monitor);
        if (this.listeners != null) {
            for (final TaskDataModelListener listener : this.listeners) {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Listener failed", e));
                    }

                    public void run() throws Exception {
                        listener.modelRefreshed();
                    }
                });
            }
        }
    }

    public void removeModelListener(TaskDataModelListener listener) {
        this.listeners.remove(listener);
    }

    public void revert() {
        this.workingCopy.revert();
        this.unsavedChangedAttributes.clear();
    }

    public void save(IProgressMonitor monitor) throws CoreException {
        this.workingCopy.save(this.unsavedChangedAttributes, monitor);
        this.unsavedChangedAttributes.clear();
    }
}

