/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.mylyn.internal.builds.ui.editor.AbstractBuildEditorPart;
import org.eclipse.mylyn.internal.builds.ui.editor.ActionPart;
import org.eclipse.mylyn.internal.builds.ui.editor.ArtifactsPart;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditorPage;
import org.eclipse.mylyn.internal.builds.ui.editor.ChangesPart;
import org.eclipse.mylyn.internal.builds.ui.editor.HeaderPart;
import org.eclipse.mylyn.internal.builds.ui.editor.SummaryPart;
import org.eclipse.mylyn.internal.builds.ui.editor.TestResultPart;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class BuildDetailsPage
extends BuildEditorPage {
    public static final String BUILD_EDITOR_PAGE_ID = "org.eclipse.mylyn.build.ui.editor.DetailsPage";
    private Form form;
    private List<AbstractBuildEditorPart> parts;
    private FormToolkit toolkit;

    public BuildDetailsPage(FormEditor editor, String title) {
        super(editor, BUILD_EDITOR_PAGE_ID, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        this.form = managedForm.getForm().getForm();
        this.toolkit = managedForm.getToolkit();
        Composite body = this.form.getBody();
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        body.setLayout((Layout)layout);
        for (AbstractBuildEditorPart part : this.parts) {
            part.initialize(this);
            this.getManagedForm().addPart((IFormPart)part);
            Control control = part.createControl(body, this.toolkit);
            part.setControl(control);
            int span = part.getSpan();
            TableWrapData data = new TableWrapData();
            data.colspan = span;
            data.align = 128;
            data.valign = 128;
            data.grabHorizontal = true;
            part.getControl().setLayoutData((Object)data);
        }
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.parts = new ArrayList<AbstractBuildEditorPart>();
        this.parts.add(new HeaderPart());
        this.parts.add(new SummaryPart());
        this.parts.add(new ActionPart());
        this.parts.add(new TestResultPart());
        this.parts.add(new ArtifactsPart());
        this.parts.add(new ChangesPart());
    }

    public void setFocus() {
        this.getManagedForm().getForm().getForm().getBody().setFocus();
    }
}

