/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.builds.core.BuildState;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.internal.core.BuildPackage;
import org.eclipse.mylyn.commons.core.DateUtil;
import org.eclipse.mylyn.internal.builds.ui.editor.AbstractBuildEditorPart;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class HeaderPart
extends AbstractBuildEditorPart {
    private DataBindingContext dbc;

    public HeaderPart() {
        this.span = 2;
    }

    protected Control createContent(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        composite.setLayout((Layout)new GridLayout());
        Label label = this.createLabel(composite, toolkit, "Plan:");
        GridDataFactory.defaultsFor((Control)label).indent(0, 0).applyTo((Control)label);
        Text text = this.createTextReadOnly(composite, toolkit, "");
        this.bind(text, IBuildPlan.class, (EStructuralFeature)BuildPackage.Literals.BUILD_ELEMENT__NAME);
        label = this.createLabel(composite, toolkit, "Build:");
        GridDataFactory.defaultsFor((Control)label).indent(12, 0).applyTo((Control)label);
        text = this.createTextReadOnly(composite, toolkit, "");
        this.bind(text, IBuild.class, (EStructuralFeature)BuildPackage.Literals.BUILD__BUILD_NUMBER);
        label = this.createLabel(composite, toolkit, "Status: ");
        GridDataFactory.defaultsFor((Control)label).indent(12, 0).applyTo((Control)label);
        text = this.createTextReadOnly(composite, toolkit, "");
        IBuild build = this.getInput(IBuild.class);
        text.setText(this.getStatusLabel(build));
        label = this.createLabel(composite, toolkit, "Duration: ");
        GridDataFactory.defaultsFor((Control)label).indent(12, 0).applyTo((Control)label);
        text = this.createTextReadOnly(composite, toolkit, "");
        text.setText(DateUtil.getFormattedDurationShort((long)build.getDuration(), (boolean)true));
        ((GridLayout)composite.getLayout()).numColumns = composite.getChildren().length;
        toolkit.paintBordersFor(composite);
        return composite;
    }

    private String getStatusLabel(IBuild build) {
        if (build.getStatus() != null) {
            return build.getStatus().getLabel();
        }
        return build.getState() == BuildState.RUNNING ? "Running" : "Unknown";
    }

    public Control createControl(Composite parent, FormToolkit toolkit) {
        return this.createContent(parent, toolkit);
    }
}

