/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.util;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.junit.model.TestRunSession;
import org.eclipse.jdt.junit.launcher.JUnitLaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.internal.builds.ui.util.TestResultManager;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.internal.provisional.commons.ui.ICoreRunnable;
import org.eclipse.osgi.util.NLS;

class TestResultSession
extends TestRunSession {
    TestResultSession(IBuild build) {
        super(NLS.bind((String)"Test Results for Build {0}", (Object)build.getLabel()), null);
    }

    public boolean rerunTest(String testId, String className, String testName, String launchMode) throws CoreException {
        return this.rerunTest(testId, className, testName, launchMode, false);
    }

    public boolean rerunTest(String testId, final String className, final String testName, String launchMode, boolean buildBeforeLaunch) throws CoreException {
        final AtomicReference result = new AtomicReference();
        CommonUiUtil.busyCursorWhile((ICoreRunnable)new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IType type = TestResultManager.Runner.findType(className, monitor);
                if (type == null) {
                    return;
                }
                if (testName != null) {
                    IMethod method = type.getMethod(testName, new String[0]);
                    if (method != null && method.exists()) {
                        result.set(method);
                    } else {
                        result.set(type);
                    }
                }
            }
        });
        if (result.get() == null) {
            String typeName = className;
            if (testName != null) {
                typeName = String.valueOf(typeName) + "." + testName + "()";
            }
            throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.builds.ui", NLS.bind((String)"Launch failed: Test ''{0}'' not found in workspace.", (Object)typeName)));
        }
        JUnitLaunchShortcut shortcut = new JUnitLaunchShortcut();
        shortcut.launch((ISelection)new StructuredSelection(result.get()), launchMode);
        return true;
    }
}

