/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.discovery.tests.DiscoveryTestConstants;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.RemoteBundleDiscoveryStrategy;

public class RemoteBundleDiscoveryStrategyTest
extends TestCase {
    private RemoteBundleDiscoveryStrategy discoveryStrategy;

    protected void setUp() throws Exception {
        this.discoveryStrategy = new RemoteBundleDiscoveryStrategy();
        this.discoveryStrategy.setDirectoryUrl(DiscoveryTestConstants.DEFAULT_MYLYN_DISCOVERY_URL);
        this.discoveryStrategy.setCategories(new ArrayList());
        this.discoveryStrategy.setConnectors(new ArrayList());
        this.discoveryStrategy.setCertifications(new ArrayList());
    }

    public void testPerformDiscovery() throws CoreException, IOException {
        this.discoveryStrategy.performDiscovery((IProgressMonitor)new NullProgressMonitor());
        RemoteBundleDiscoveryStrategyTest.assertFalse((boolean)this.discoveryStrategy.getCategories().isEmpty());
        for (DiscoveryCategory category : this.discoveryStrategy.getCategories()) {
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)category.getId());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)category.getName());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)category.getDescription());
        }
        RemoteBundleDiscoveryStrategyTest.assertFalse((boolean)this.discoveryStrategy.getConnectors().isEmpty());
        for (DiscoveryConnector connector : this.discoveryStrategy.getConnectors()) {
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)connector.getId());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)connector.getKind());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)connector.getName());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)connector.getDescription());
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)connector.getSource());
            URL pluginXmlUrl = connector.getSource().getResource("plugin.xml");
            InputStream in = pluginXmlUrl.openStream();
            RemoteBundleDiscoveryStrategyTest.assertNotNull((Object)in);
            in.close();
        }
    }
}

