/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core.mock;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.discovery.tests.core.mock.DiscoveryCategoryMockFactory;
import org.eclipse.mylyn.discovery.tests.core.mock.DiscoveryConnectorMockFactory;
import org.eclipse.mylyn.internal.discovery.core.model.AbstractDiscoveryStrategy;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;

public class MockDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private int connectorCount = 15;
    private int categoryCount = 5;
    protected DiscoveryConnectorMockFactory connectorMockFactory = new DiscoveryConnectorMockFactory();
    protected DiscoveryCategoryMockFactory categoryMockFactory = new DiscoveryCategoryMockFactory();

    public void performDiscovery(IProgressMonitor monitor) throws CoreException {
        int x = 0;
        while (x < this.categoryCount) {
            DiscoveryCategory mockCategory = this.createDiscoveryCategory();
            this.getCategories().add(mockCategory);
            ++x;
        }
        x = 0;
        while (x < this.connectorCount) {
            DiscoveryConnector mockConnector = this.createDiscoveryConnector();
            if (!this.getCategories().isEmpty()) {
                int categoryIndex = x % this.getCategories().size();
                mockConnector.setCategoryId(((DiscoveryCategory)this.getCategories().get(categoryIndex)).getId());
            }
            this.getConnectors().add(mockConnector);
            ++x;
        }
    }

    protected DiscoveryCategory createDiscoveryCategory() {
        return (DiscoveryCategory)this.categoryMockFactory.get();
    }

    protected DiscoveryConnector createDiscoveryConnector() {
        return (DiscoveryConnector)this.connectorMockFactory.get();
    }

    public DiscoveryCategoryMockFactory getCategoryMockFactory() {
        return this.categoryMockFactory;
    }

    public void setCategoryMockFactory(DiscoveryCategoryMockFactory categoryMockFactory) {
        this.categoryMockFactory = categoryMockFactory;
    }

    public DiscoveryConnectorMockFactory getConnectorMockFactory() {
        return this.connectorMockFactory;
    }

    public void setConnectorMockFactory(DiscoveryConnectorMockFactory connectorMockFactory) {
        this.connectorMockFactory = connectorMockFactory;
    }

    public int getConnectorCount() {
        return this.connectorCount;
    }

    public void setConnectorCount(int connectorCount) {
        this.connectorCount = connectorCount;
    }

    public int getCategoryCount() {
        return this.categoryCount;
    }

    public void setCategoryCount(int categoryCount) {
        this.categoryCount = categoryCount;
    }
}

