/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core.util;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.util.DiscoveryCategoryComparator;

public class DiscoveryCategoryComparatorTest
extends TestCase {
    private DiscoveryCategoryComparator comparator;
    private DiscoveryCategory category1;
    private DiscoveryCategory category2;

    protected void setUp() throws Exception {
        super.setUp();
        this.comparator = new DiscoveryCategoryComparator();
        this.category1 = new DiscoveryCategory();
        this.category2 = new DiscoveryCategory();
    }

    public void testSortByRelevanceInequal() {
        this.category1.setRelevance("100");
        this.category2.setRelevance("50");
        DiscoveryCategoryComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(this.category1, this.category2));
        DiscoveryCategoryComparatorTest.assertEquals((int)1, (int)this.comparator.compare(this.category2, this.category1));
    }

    public void testSortByRelevanceOneNotSpecified() {
        this.category1.setRelevance("10");
        DiscoveryCategoryComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(this.category1, this.category2));
        DiscoveryCategoryComparatorTest.assertEquals((int)1, (int)this.comparator.compare(this.category2, this.category1));
    }

    public void testSortByRelevanceSame() {
        this.category1.setRelevance("10");
        this.category1.setName("test");
        this.category1.setId("1");
        this.category2.setRelevance("10");
        this.category2.setName("test");
        this.category2.setId("1");
        DiscoveryCategoryComparatorTest.assertEquals((int)0, (int)this.comparator.compare(this.category1, this.category2));
        DiscoveryCategoryComparatorTest.assertEquals((int)0, (int)this.comparator.compare(this.category2, this.category1));
    }

    public void testSortByRelevanceSameIdsDiffer() {
        this.category1.setRelevance("10");
        this.category1.setName("test");
        this.category1.setId("a");
        this.category2.setRelevance("10");
        this.category2.setName("test");
        this.category2.setId("b");
        DiscoveryCategoryComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(this.category1, this.category2));
        DiscoveryCategoryComparatorTest.assertEquals((int)1, (int)this.comparator.compare(this.category2, this.category1));
    }

    public void testSortByRelevanceSameNamesDiffer() {
        this.category1.setRelevance("10");
        this.category1.setName("a");
        this.category1.setId("a");
        this.category2.setRelevance("10");
        this.category2.setName("b");
        this.category2.setId("a");
        DiscoveryCategoryComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(this.category1, this.category2));
        DiscoveryCategoryComparatorTest.assertEquals((int)1, (int)this.comparator.compare(this.category2, this.category1));
    }
}

