/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.discovery.tests.core.util;

import junit.framework.TestCase;
import org.eclipse.mylyn.internal.discovery.core.model.ConnectorCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryCategory;
import org.eclipse.mylyn.internal.discovery.core.model.DiscoveryConnector;
import org.eclipse.mylyn.internal.discovery.core.model.Group;
import org.eclipse.mylyn.internal.discovery.core.util.DiscoveryConnectorComparator;

public class DiscoveryConnectorComparatorTest
extends TestCase {
    private DiscoveryCategory category;
    private DiscoveryConnectorComparator comparator;

    protected void setUp() throws Exception {
        super.setUp();
        this.category = new DiscoveryCategory();
        this.comparator = new DiscoveryConnectorComparator((ConnectorCategory)this.category);
    }

    private Group addGroup(String id) {
        Group group = new Group();
        group.setId(id);
        this.category.getGroup().add(group);
        return group;
    }

    private DiscoveryConnector addConnectorDescriptor(String id, String name, String groupId) {
        DiscoveryConnector connector = new DiscoveryConnector();
        connector.setId(id);
        connector.setName(name);
        connector.setGroupId(groupId);
        connector.setCategory(this.category);
        this.category.getConnectors().add(connector);
        return connector;
    }

    public void testOrderByGroup() {
        this.addGroup("1");
        this.addGroup("2");
        DiscoveryConnector t1 = this.addConnectorDescriptor("b", "btest", "2");
        DiscoveryConnector t2 = this.addConnectorDescriptor("a", "atest", "2");
        DiscoveryConnector t3 = this.addConnectorDescriptor("c", "ctest", "1");
        DiscoveryConnector t4 = this.addConnectorDescriptor("d", "dtest", "1");
        DiscoveryConnector t5 = this.addConnectorDescriptor("0", "0test", null);
        DiscoveryConnectorComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(t2, t1));
        DiscoveryConnectorComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t1, t2));
        DiscoveryConnectorComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(t3, t4));
        DiscoveryConnectorComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t4, t3));
        DiscoveryConnectorComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(t1, t5));
        DiscoveryConnectorComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t5, t1));
        DiscoveryConnectorComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(t2, t5));
        DiscoveryConnectorComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t5, t2));
        DiscoveryConnectorComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(t3, t5));
        DiscoveryConnectorComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t5, t3));
        DiscoveryConnectorComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(t4, t5));
        DiscoveryConnectorComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t5, t4));
        DiscoveryConnectorComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(t3, t1));
        DiscoveryConnectorComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t1, t3));
        DiscoveryConnectorComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(t3, t2));
        DiscoveryConnectorComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t2, t3));
        DiscoveryConnectorComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(t4, t1));
        DiscoveryConnectorComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t1, t4));
        DiscoveryConnectorComparatorTest.assertEquals((int)-1, (int)this.comparator.compare(t4, t2));
        DiscoveryConnectorComparatorTest.assertEquals((int)1, (int)this.comparator.compare(t2, t4));
    }
}

