/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylyn.internal.provisional.commons.ui.CommonUiUtil;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiExtensionPointReader;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiPreferenceInitializer;
import org.eclipse.mylyn.internal.resources.ui.preferences.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusedResourcesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final Color GRAY = new Color((Device)Display.getDefault(), 100, 100, 100);
    private static final String LABEL_AUTOMATIC = Messages.FocusedResourcesPreferencePage__automatic_;
    private Table ignoreTable;
    private Button addButton;
    private Button removeButton;
    private Button resourceMonitoringButton;
    private Group monitoringExclusionsGroup;

    public void init(IWorkbench workbench) {
        this.setDescription(Messages.FocusedResourcesPreferencePage_Configure_file_change_monitoring_Description);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ResourcesUiBridgePlugin.getDefault().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.resourceMonitoringButton = new Button(composite, 96);
        this.resourceMonitoringButton.setText(Messages.FocusedResourcesPreferencePage__Enable_file_change_monitoring_Label);
        boolean resourceModificationsEnabled = this.getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.resources.resource.monitor.enabled");
        this.resourceMonitoringButton.setSelection(resourceModificationsEnabled);
        this.resourceMonitoringButton.setLayoutData((Object)new GridData(768));
        this.resourceMonitoringButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FocusedResourcesPreferencePage.this.updateEnablement();
            }
        });
        this.createExcludesTable(composite);
        this.updateEnablement();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void updateEnablement() {
        boolean enabled = this.resourceMonitoringButton.getSelection();
        if (enabled != this.monitoringExclusionsGroup.isEnabled()) {
            CommonUiUtil.setEnabled((Composite)this.monitoringExclusionsGroup, (boolean)enabled);
        }
        if (enabled) {
            if (this.ignoreTable.getSelectionCount() > 0) {
                this.removeButton.setEnabled(true);
            } else {
                this.removeButton.setEnabled(false);
            }
        }
    }

    private void createExcludesTable(Composite parent) {
        this.monitoringExclusionsGroup = new Group(parent, 16);
        this.monitoringExclusionsGroup.setText(Messages.FocusedResourcesPreferencePage_Resource_Monitoring_Exclusions);
        GridLayout layout = new GridLayout(1, false);
        this.monitoringExclusionsGroup.setLayoutData((Object)new GridData(1808));
        this.monitoringExclusionsGroup.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)this.monitoringExclusionsGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        Label l1 = new Label(composite, 0);
        l1.setText(Messages.FocusedResourcesPreferencePage_Matching_file_or_directory_names_will_not_be_added_automatically_to_the_context);
        GridData data = new GridData(2);
        data.horizontalSpan = 2;
        l1.setLayoutData((Object)data);
        this.ignoreTable = new Table(composite, 2048);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).applyTo((Control)this.ignoreTable);
        this.ignoreTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FocusedResourcesPreferencePage.this.updateEnablement();
            }
        });
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(Messages.FocusedResourcesPreferencePage_Add_);
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FocusedResourcesPreferencePage.this.addIgnore();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(Messages.FocusedResourcesPreferencePage_Remove);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FocusedResourcesPreferencePage.this.removeIgnore();
            }
        });
        this.fillTable(ResourcesUiPreferenceInitializer.getExcludedResourcePatterns(), ResourcesUiPreferenceInitializer.getForcedExcludedResourcePatterns());
        this.setButtonLayoutData(this.addButton);
        this.setButtonLayoutData(this.removeButton);
    }

    public boolean performOk() {
        ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.ide.resources.resource.monitor.enabled", this.resourceMonitoringButton.getSelection());
        HashSet<String> patterns = new HashSet<String>();
        TableItem[] items = this.ignoreTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (!items[i].getText().endsWith(LABEL_AUTOMATIC)) {
                patterns.add(items[i].getText());
            }
            ++i;
        }
        ResourcesUiPreferenceInitializer.setExcludedResourcePatterns(patterns);
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        boolean resourceModificationsEnabled = ResourcesUiBridgePlugin.getDefault().getPreferenceStore().getDefaultBoolean("org.eclipse.mylyn.ide.resources.resource.monitor.enabled");
        this.resourceMonitoringButton.setSelection(resourceModificationsEnabled);
        this.ignoreTable.removeAll();
        this.fillTable(ResourcesUiExtensionPointReader.getDefaultResourceExclusions(), ResourcesUiPreferenceInitializer.getForcedExcludedResourcePatterns());
    }

    private void fillTable(Set<String> ignored, Set<String> forced) {
        TableItem item;
        for (String pattern : ignored) {
            item = new TableItem(this.ignoreTable, 0);
            item.setText(pattern);
        }
        for (String pattern : forced) {
            item = new TableItem(this.ignoreTable, 0);
            item.setText(String.valueOf(pattern) + " " + LABEL_AUTOMATIC);
            item.setForeground(GRAY);
        }
    }

    private void addIgnore() {
        InputDialog dialog = new InputDialog(this.getShell(), Messages.FocusedResourcesPreferencePage_Add__IGNORED_RESOURCE, Messages.FocusedResourcesPreferencePage_Enter_pattern_____any_string_, null, null);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        String pattern = dialog.getValue();
        if (pattern.equals("")) {
            return;
        }
        TableItem item = new TableItem(this.ignoreTable, 0);
        item.setText(pattern);
        item.setChecked(true);
    }

    private void removeIgnore() {
        int[] selection = this.ignoreTable.getSelectionIndices();
        this.ignoreTable.remove(selection);
    }
}

