/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.team.tests;

import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.ide.ui.IdeUiBridgePlugin;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.team.ui.ContextActiveChangeSetManager;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.resources.tests.AbstractResourceContextTest;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.team.ui.IContextChangeSet;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSet;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;
import org.eclipse.team.internal.core.subscribers.ChangeSet;
import org.eclipse.ui.IWorkbenchPart;

public class ChangeSetManagerTest
extends AbstractResourceContextTest {
    private ContextActiveChangeSetManager changeSetManager;
    private ActiveChangeSetManager collector;

    protected void setUp() throws Exception {
        super.setUp();
        ChangeSetManagerTest.assertNotNull((Object)IdeUiBridgePlugin.getDefault());
        this.changeSetManager = (ContextActiveChangeSetManager)FocusedTeamUiPlugin.getDefault().getContextChangeSetManagers().iterator().next();
        this.collector = CVSUIPlugin.getPlugin().getChangeSetManager();
        ChangeSetManagerTest.assertNotNull((Object)this.changeSetManager);
        ChangeSetManagerTest.assertNull((Object)TasksUiPlugin.getTaskActivityManager().getActiveTask());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testDisabledMode() {
        ChangeSet[] sets;
        ChangeSet[] changeSetArray = sets = this.collector.getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            this.collector.remove(set);
            ++n2;
        }
        ChangeSetManagerTest.assertEquals((int)0, (int)this.collector.getSets().length);
        this.manager.deactivateContext(this.taskId);
        this.changeSetManager.clearActiveChangeSets();
        ChangeSetManagerTest.assertEquals((int)0, (int)this.changeSetManager.getActiveChangeSets().size());
        this.changeSetManager.disable();
        LocalTask task1 = new LocalTask("task1", "label");
        TasksUiPlugin.getTaskActivityManager().activateTask((ITask)task1);
        ChangeSetManagerTest.assertEquals((int)0, (int)this.changeSetManager.getActiveChangeSets().size());
        ChangeSetManagerTest.assertEquals((int)0, (int)this.collector.getSets().length);
        TasksUiPlugin.getTaskActivityManager().deactivateTask((ITask)task1);
        this.changeSetManager.enable();
    }

    public void testSingleContextActivation() {
        ChangeSet[] sets;
        ChangeSet[] changeSetArray = sets = this.collector.getSets();
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSet set = changeSetArray[n2];
            this.collector.remove(set);
            ++n2;
        }
        ChangeSetManagerTest.assertEquals((int)0, (int)this.collector.getSets().length);
        this.manager.deactivateContext(this.taskId);
        this.changeSetManager.clearActiveChangeSets();
        ChangeSetManagerTest.assertEquals((int)0, (int)this.changeSetManager.getActiveChangeSets().size());
        LocalTask task1 = new LocalTask("task1", "label");
        TasksUiPlugin.getTaskActivityManager().activateTask((ITask)task1);
        ChangeSetManagerTest.assertEquals((int)1, (int)this.changeSetManager.getActiveChangeSets().size());
        ChangeSetManagerTest.assertEquals((int)1, (int)this.collector.getSets().length);
        TasksUiPlugin.getTaskActivityManager().deactivateTask((ITask)task1);
        ChangeSetManagerTest.assertFalse((boolean)ContextCore.getContextManager().isContextActive());
        ChangeSetManagerTest.assertEquals((int)0, (int)this.changeSetManager.getActiveChangeSets().size());
        ChangeSetManagerTest.assertEquals((int)0, (int)this.collector.getSets().length);
        TasksUiPlugin.getTaskActivityManager().deactivateTask((ITask)task1);
    }

    public void testContentsAfterDecay() throws CoreException {
        IFile file = this.project.getProject().getFile((IPath)new Path("foo.txt"));
        file.create(null, true, null);
        LocalTask task1 = new LocalTask("task1", "label");
        TasksUiPlugin.getTaskActivityManager().activateTask((ITask)task1);
        this.monitor.selectionChanged((IWorkbenchPart)this.navigator, (ISelection)new StructuredSelection((Object)file));
        IInteractionElement fileElement = ContextCore.getContextManager().getElement(this.structureBridge.getHandleIdentifier((Object)file));
        ChangeSetManagerTest.assertTrue((boolean)fileElement.getInterest().isInteresting());
        List changeSets = this.changeSetManager.getActiveChangeSets();
        ChangeSetManagerTest.assertEquals((int)1, (int)changeSets.size());
        IContextChangeSet set = (IContextChangeSet)changeSets.get(0);
        IResource[] resources = ((ActiveChangeSet)set).getResources();
        ChangeSetManagerTest.assertTrue((String)("length: " + resources.length), (resources.length <= 2 ? 1 : 0) != 0);
        int i = 0;
        while ((float)i < 1.0f / this.scaling.getDecay() * 3.0f) {
            ContextCore.getContextManager().processInteractionEvent(this.mockSelection());
            ++i;
        }
        ChangeSetManagerTest.assertTrue((String)("" + fileElement.getInterest().getValue()), (fileElement.getInterest().getValue() < 0.0f ? 1 : 0) != 0);
        ChangeSetManagerTest.assertTrue((String)("length: " + resources.length), (resources.length <= 2 ? 1 : 0) != 0);
        TasksUiPlugin.getTaskActivityManager().deactivateTask((ITask)task1);
    }
}

