/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.team.tests;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.internal.team.ui.ContextChangeSet;
import org.eclipse.mylyn.internal.team.ui.FocusedTeamUiPlugin;
import org.eclipse.mylyn.internal.team.ui.properties.TeamPropertiesLinkProvider;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.internal.core.subscribers.ActiveChangeSetManager;

public class TeamPropertiesLinkProviderTest
extends TestCase {
    private IProject project1;
    private List<IResource> resources;
    private IProject project2;

    protected void setUp() throws Exception {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project1 = root.getProject("Test Project1");
        this.project1.create(null);
        this.project1.open(null);
        this.project2 = root.getProject("Test Project2");
        this.project2.create(null);
        this.project2.open(null);
        this.resources = new ArrayList<IResource>();
    }

    protected void tearDown() throws Exception {
        this.project1.delete(true, null);
        this.project2.delete(true, null);
    }

    public void testCommitCommentTemplate() throws Exception {
        MockTask task = new MockTask("1");
        task.setSummary("summary");
        task.setUrl("http://url");
        ContextChangeSet changeSet = new ContextChangeSet((ITask)task, new StubChangeSetManager()){

            public IResource[] getChangedResources() {
                return TeamPropertiesLinkProviderTest.this.resources.toArray(new IResource[0]);
            }
        };
        this.resources.add((IResource)this.project1);
        FocusedTeamUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.team.commit.template", "${task.key}: ${task.description}");
        TeamPropertiesLinkProviderTest.assertEquals((String)"1: summary", (String)changeSet.getComment());
        TeamPropertiesLinkProvider linkProvider = new TeamPropertiesLinkProvider();
        TeamPropertiesLinkProviderTest.assertNull((Object)linkProvider.getCommitCommentTemplate((IResource)this.project1));
        TeamPropertiesLinkProviderTest.assertTrue((boolean)linkProvider.canAccessProperties((IResource)this.project1));
        TeamPropertiesLinkProviderTest.assertTrue((boolean)linkProvider.setCommitCommentTemplate((IResource)this.project1, "ab${task.url}cd"));
        TeamPropertiesLinkProviderTest.assertEquals((String)"ab${task.url}cd", (String)linkProvider.getCommitCommentTemplate((IResource)this.project1));
        TeamPropertiesLinkProviderTest.assertEquals((String)"abhttp://urlcd", (String)changeSet.getComment());
        TeamPropertiesLinkProviderTest.assertTrue((boolean)linkProvider.canAccessProperties((IResource)this.project1));
        IFile file = this.project1.getFile("file");
        file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
        this.resources.clear();
        this.resources.add((IResource)file);
        TeamPropertiesLinkProviderTest.assertEquals((String)"ab${task.url}cd", (String)linkProvider.getCommitCommentTemplate((IResource)file));
        TeamPropertiesLinkProviderTest.assertEquals((String)"abhttp://urlcd", (String)changeSet.getComment());
        TeamPropertiesLinkProviderTest.assertTrue((boolean)linkProvider.canAccessProperties((IResource)file));
        linkProvider.setCommitCommentTemplate((IResource)file, null);
        TeamPropertiesLinkProviderTest.assertNull((Object)linkProvider.getCommitCommentTemplate((IResource)file));
        TeamPropertiesLinkProviderTest.assertNull((Object)linkProvider.getCommitCommentTemplate((IResource)this.project1));
        TeamPropertiesLinkProviderTest.assertTrue((boolean)linkProvider.canAccessProperties((IResource)file));
        TeamPropertiesLinkProviderTest.assertTrue((boolean)linkProvider.canAccessProperties((IResource)this.project1));
    }

    public void testChangeSetCommitCommentMultipleProjects() throws Exception {
        MockTask task = new MockTask("1");
        task.setSummary("summary");
        task.setUrl("http://url");
        ContextChangeSet changeSet = new ContextChangeSet((ITask)task, new StubChangeSetManager()){

            public IResource[] getChangedResources() {
                return TeamPropertiesLinkProviderTest.this.resources.toArray(new IResource[0]);
            }
        };
        this.resources.add((IResource)this.project1);
        FocusedTeamUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.team.commit.template", "global template: ${task.key}");
        TeamPropertiesLinkProvider linkProvider = new TeamPropertiesLinkProvider();
        TeamPropertiesLinkProviderTest.assertTrue((boolean)linkProvider.setCommitCommentTemplate((IResource)this.project2, "project template: ${task.key}"));
        this.resources.add((IResource)this.project1);
        TeamPropertiesLinkProviderTest.assertEquals((String)"global template: 1", (String)changeSet.getComment());
        this.resources.add((IResource)this.project2);
        TeamPropertiesLinkProviderTest.assertEquals((String)"project template: 1", (String)changeSet.getComment());
    }

    public void testChangeSetCommitCommentChangedResources() throws Exception {
        MockTask task = new MockTask("1");
        task.setSummary("summary");
        task.setUrl("http://url");
        ContextChangeSet changeSet = new ContextChangeSet((ITask)task, new StubChangeSetManager()){

            public IResource[] getResources() {
                return new IResource[]{TeamPropertiesLinkProviderTest.this.project1, TeamPropertiesLinkProviderTest.this.project2};
            }

            public IResource[] getChangedResources() {
                return new IResource[]{TeamPropertiesLinkProviderTest.this.project2};
            }
        };
        FocusedTeamUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.team.commit.template", "global");
        TeamPropertiesLinkProvider linkProvider = new TeamPropertiesLinkProvider();
        TeamPropertiesLinkProviderTest.assertTrue((boolean)linkProvider.setCommitCommentTemplate((IResource)this.project1, "project1"));
        TeamPropertiesLinkProviderTest.assertEquals((String)"global", (String)changeSet.getComment());
        TeamPropertiesLinkProviderTest.assertTrue((boolean)linkProvider.setCommitCommentTemplate((IResource)this.project2, "project2"));
        TeamPropertiesLinkProviderTest.assertEquals((String)"project2", (String)changeSet.getComment());
    }

    public class StubChangeSetManager
    extends ActiveChangeSetManager {
        public IDiff getDiff(IResource resource) throws CoreException {
            return null;
        }

        protected String getName() {
            return null;
        }

        protected void initializeSets() {
        }
    }
}

