/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests;

import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mylyn.bugzilla.tests.support.BugzillaFixture;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskDataModel;
import org.eclipse.mylyn.tasks.core.sync.SubmitJob;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.mylyn.tests.util.TestFixture;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBugzillaTest
extends TestCase {
    static final String DEFAULT_KIND = "bugzilla";
    protected BugzillaRepositoryConnector connector;
    protected TaskRepositoryManager manager;
    protected TaskRepository repository;
    protected TaskList taskList;
    protected BugzillaClient client;

    protected void setUp() throws Exception {
        super.setUp();
        TasksUiPlugin.getDefault().getPreferenceStore().setValue("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule", false);
        this.manager = TasksUiPlugin.getRepositoryManager();
        TestFixture.resetTaskListAndRepositories();
        this.client = BugzillaFixture.current().client();
        this.connector = BugzillaFixture.current().connector();
        this.repository = BugzillaFixture.current().repository();
        TasksUi.getRepositoryManager().addRepository(this.repository);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        TestFixture.resetTaskList();
        this.manager.clearRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
    }

    protected TaskDataModel createModel(ITask task) throws CoreException {
        ITaskDataWorkingCopy taskDataState = this.getWorkingCopy(task);
        return new TaskDataModel(this.repository, task, taskDataState);
    }

    protected ITaskDataWorkingCopy getWorkingCopy(ITask task) throws CoreException {
        return TasksUiPlugin.getTaskDataManager().getWorkingCopy(task);
    }

    protected void submit(TaskDataModel model) {
        SubmitJob submitJob = TasksUiInternal.getJobFactory().createSubmitTaskJob((AbstractRepositoryConnector)this.connector, model.getTaskRepository(), model.getTask(), model.getTaskData(), model.getChangedOldAttributes());
        submitJob.schedule();
        try {
            submitJob.join();
        }
        catch (InterruptedException e) {
            AbstractBugzillaTest.fail((String)e.getMessage());
        }
    }

    protected void synchAndAssertState(Set<ITask> tasks, ITask.SynchronizationState state) {
        for (ITask task : tasks) {
            TasksUiInternal.synchronizeTask((AbstractRepositoryConnector)this.connector, (ITask)task, (boolean)true, null);
            TasksUiPlugin.getTaskDataManager().setTaskRead(task, true);
            AbstractBugzillaTest.assertEquals((Object)task.getSynchronizationState(), (Object)state);
        }
    }

    public ITask generateLocalTaskAndDownload(String id) throws CoreException {
        ITask task = TasksUi.getRepositoryModel().createTask(this.repository, id);
        TasksUiPlugin.getTaskList().addTask(task);
        TasksUiInternal.synchronizeTask((AbstractRepositoryConnector)this.connector, (ITask)task, (boolean)true, null);
        TasksUiPlugin.getTaskDataManager().setTaskRead(task, true);
        return task;
    }
}

