/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.support;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import junit.framework.AssertionFailedError;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.WebLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.sdk.util.CommonTestUtil;
import org.eclipse.mylyn.commons.sdk.util.TestConfiguration;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClient;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaClientManager;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaRepositoryConnector;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaVersion;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.eclipse.mylyn.tests.util.TestFixture;

public class BugzillaFixture
extends TestFixture {
    public static final String TEST_BUGZILLA_34_URL = BugzillaFixture.getServerUrl("bugs34");
    public static final String TEST_BUGZILLA_36_URL = BugzillaFixture.getServerUrl("bugs36");
    public static final String TEST_BUGZILLA_40_URL = BugzillaFixture.getServerUrl("bugs40");
    public static final String TEST_BUGZILLA_42_URL = BugzillaFixture.getServerUrl("bugs42");
    public static final String TEST_BUGZILLA_HEAD_URL = BugzillaFixture.getServerUrl("bugshead");
    public static final String CUSTOM_WF = "Custom Workflow";
    public static final String CUSTOM_WF_AND_STATUS = "Custom Workflow and Status";
    public static final String XML_RPC_DISABLED = "XML-RPC disabled";
    private static BugzillaFixture current;
    @Deprecated
    public static BugzillaFixture BUGS_3_4;
    public static BugzillaFixture BUGS_3_6;
    public static BugzillaFixture BUGS_3_6_CUSTOM_WF;
    public static BugzillaFixture BUGS_3_6_CUSTOM_WF_AND_STATUS;
    public static BugzillaFixture BUGS_3_6_XML_RPC_DISABLED;
    public static BugzillaFixture BUGS_4_0;
    public static BugzillaFixture BUGS_4_2;
    public static BugzillaFixture BUGS_HEAD;
    public static BugzillaFixture DEFAULT;
    public static final BugzillaFixture[] ALL;
    private final String version;
    private final BugzillaVersion bugzillaVersion;

    static {
        BUGS_3_4 = new BugzillaFixture(TEST_BUGZILLA_34_URL, "3.4.14", "");
        BUGS_3_6 = new BugzillaFixture(TEST_BUGZILLA_36_URL, "3.6.9", "");
        BUGS_3_6_CUSTOM_WF = new BugzillaFixture(String.valueOf(TEST_BUGZILLA_36_URL) + "-custom-wf", "3.6.9", CUSTOM_WF);
        BUGS_3_6_CUSTOM_WF_AND_STATUS = new BugzillaFixture(String.valueOf(TEST_BUGZILLA_36_URL) + "-custom-wf-and-status", "3.6.9", CUSTOM_WF_AND_STATUS);
        BUGS_3_6_XML_RPC_DISABLED = new BugzillaFixture(String.valueOf(TEST_BUGZILLA_36_URL) + "-xml-rpc-disabled", "3.6.9", XML_RPC_DISABLED);
        BUGS_4_0 = new BugzillaFixture(TEST_BUGZILLA_40_URL, "4.0.6", "");
        BUGS_4_2 = new BugzillaFixture(TEST_BUGZILLA_42_URL, "4.2.1", "");
        BUGS_HEAD = new BugzillaFixture(TEST_BUGZILLA_HEAD_URL, "4.3.1+", "");
        DEFAULT = BUGS_4_2;
        ALL = new BugzillaFixture[]{BUGS_3_4, BUGS_3_6, BUGS_3_6_XML_RPC_DISABLED, BUGS_3_6_CUSTOM_WF, BUGS_3_6_CUSTOM_WF_AND_STATUS, BUGS_4_0, BUGS_4_2, BUGS_HEAD};
    }

    private static final String getServerUrl(String version) {
        return TestConfiguration.getRepositoryUrl((String)version);
    }

    public BugzillaFixture(String url, String version, String info) {
        super("bugzilla", url);
        this.version = version;
        this.bugzillaVersion = new BugzillaVersion(version);
        this.setInfo("Bugzilla", version, info);
    }

    public BugzillaVersion getBugzillaVersion() {
        return this.bugzillaVersion;
    }

    public static void cleanup010() throws Exception {
    }

    public static BugzillaFixture current(BugzillaFixture fixture) {
        if (current == null) {
            fixture.activate();
        }
        return current;
    }

    public static BugzillaFixture current() {
        return BugzillaFixture.current(DEFAULT);
    }

    public BugzillaFixture activate() {
        current = this;
        this.setUpFramework();
        return this;
    }

    protected TestFixture getDefault() {
        return DEFAULT;
    }

    public String getVersion() {
        return this.version;
    }

    public BugzillaClient client() throws CoreException, IOException {
        UserCredentials credentials = CommonTestUtil.getCredentials((CommonTestUtil.PrivilegeLevel)CommonTestUtil.PrivilegeLevel.USER);
        return this.client(this.getRepositoryUrl(), credentials.getUserName(), credentials.getPassword(), "", "", "UTF-8");
    }

    public BugzillaClient client(String hostUrl, String username, String password, String htAuthUser, String htAuthPass, String encoding) throws CoreException, IOException {
        WebLocation location = new WebLocation(hostUrl);
        location.setCredentials(AuthenticationType.REPOSITORY, username, password);
        location.setCredentials(AuthenticationType.HTTP, htAuthUser, htAuthPass);
        return this.client((AbstractWebLocation)location, encoding);
    }

    public BugzillaClient client(AbstractWebLocation location, String encoding) throws CoreException {
        TaskRepository taskRepository = new TaskRepository("bugzilla", location.getUrl());
        String filepath = "testdata/descriptor/" + this.getInfo().replaceAll(" ", "_") + "Transition.txt";
        try {
            File file = BugzillaFixture.getFile(filepath);
            if (file != null) {
                taskRepository.setProperty("bugzilla.desciptorFile", file.getCanonicalPath());
            }
        }
        catch (AssertionFailedError assertionFailedError) {
        }
        catch (IOException iOException) {}
        taskRepository.setCredentials(AuthenticationType.REPOSITORY, location.getCredentials(AuthenticationType.REPOSITORY), false);
        taskRepository.setCredentials(AuthenticationType.HTTP, location.getCredentials(AuthenticationType.HTTP), false);
        taskRepository.setCharacterEncoding(encoding);
        BugzillaRepositoryConnector connector = new BugzillaRepositoryConnector();
        this.connector = connector;
        BugzillaClientManager bugzillaClientManager = connector.getClientManager();
        BugzillaClient client = bugzillaClientManager.getClient(taskRepository, null);
        connector.getRepositoryConfiguration(taskRepository, false, (IProgressMonitor)new NullProgressMonitor());
        connector.writeRepositoryConfigFile();
        return client;
    }

    public BugzillaClient client(CommonTestUtil.PrivilegeLevel level) throws Exception {
        AbstractWebLocation location = this.location(level);
        return this.client(location, "UTF-8");
    }

    public static File getFile(String filename) throws IOException {
        return CommonTestUtil.getFile(BugzillaFixture.class, (String)filename);
    }

    public static InputStream getResource(String filename) throws IOException {
        return CommonTestUtil.getResource(BugzillaFixture.class, (String)filename);
    }

    public TaskData createTask(CommonTestUtil.PrivilegeLevel level, String summary, String description) throws Exception {
        if (summary == null) {
            summary = "summary";
        }
        if (description == null) {
            description = "description";
        }
        BugzillaClient client = this.client(level);
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository());
        TaskData taskData = new TaskData(mapper, this.repository().getConnectorKind(), this.repository().getRepositoryUrl(), "");
        taskDataHandler.initializeTaskData(this.repository(), taskData, null, null);
        taskData.getRoot().createMappedAttribute("task.common.summary").setValue(summary);
        taskData.getRoot().createMappedAttribute("task.common.description").setValue(description);
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.OP_SYS.getKey()).setValue("All");
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.REP_PLATFORM.getKey()).setValue("All");
        taskData.getRoot().createMappedAttribute(BugzillaAttribute.VERSION.getKey()).setValue("unspecified");
        RepositoryResponse response = this.submitTask(taskData, client);
        String bugId = response.getTaskId();
        return this.getTask(bugId, client);
    }

    public TaskData getTask(String id, BugzillaClient client) throws Exception {
        AbstractTaskDataHandler taskDataHandler = this.connector.getTaskDataHandler();
        TaskAttributeMapper mapper = taskDataHandler.getAttributeMapper(this.repository());
        final TaskData[] newData = new TaskData[1];
        client.getTaskData(Collections.singleton(id), new TaskDataCollector(){

            public void accept(TaskData data) {
                newData[0] = data;
            }
        }, mapper, null);
        taskDataHandler.initializeTaskData(this.repository(), newData[0], null, null);
        return newData[0];
    }

    public RepositoryResponse submitTask(TaskData taskData, BugzillaClient client) throws IOException, CoreException {
        RepositoryResponse result = client.postTaskData(taskData, null);
        return result;
    }

    public BugzillaRepositoryConnector connector() {
        return (BugzillaRepositoryConnector)this.connector;
    }
}

