/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.bugzilla.tests.ui;

import junit.framework.TestCase;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.mylyn.commons.ui.PlatformUiUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskHyperlinkDetector;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TaskHyperlink;
import org.eclipse.mylyn.tasks.ui.TasksUi;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class BugzillaTaskHyperlinkDetectorTest
extends TestCase {
    private static final String DUPLICATE_NUMBER = "112233";
    private static final String DUPLICATE = "duplicate of 112233";
    private static final String ATTACHMENT_NUMBER = "445566";
    private static final String ATTACHMENT_OLD = "Created an attachment (id=445566)";
    private static final String ATTACHMENT_NEW = "Created attachment445566";
    private final String TASK_FORMAT_1 = "task#123";
    private final String TASK_FORMAT_2 = "task# 123";
    private final String TASK_FORMAT_3 = "task123";
    private final String TASK_FORMAT_4 = "task #123";
    private final String BUG_FORMAT_1 = "bug# 123";
    private final String BUG_FORMAT_2 = "bug # 123";
    private final String BUG_FORMAT_3 = "bug123";
    private final String BUG_FORMAT_4 = "bug #123";
    private final String BUG_FORMAT_1_2 = "bug# 2";
    private final String TASK_FORMAT_1_COMMENT_2 = "task#123 comment #44556677";
    private final String TASK_FORMAT_2_COMMENT_2 = "task# 123 comment #44556677";
    private final String TASK_FORMAT_3_COMMENT_2 = "task123 comment #44556677";
    private final String TASK_FORMAT_4_COMMENT_2 = "task #123 comment #44556677";
    private final String BUG_FORMAT_1_COMMENT_2 = "bug# 123 comment #44556677";
    private final String BUG_FORMAT_2_COMMENT_2 = "bug # 123 comment #44556677";
    private final String BUG_FORMAT_3_COMMENT_2 = "bug123 comment #44556677";
    private final String BUG_FORMAT_4_COMMENT_2 = "bug #123 comment #44556677";
    private final String TASK_FORMAT_1_COMMENT_3 = "task#123 comment#44556677";
    private final String TASK_FORMAT_2_COMMENT_3 = "task# 123 comment#44556677";
    private final String TASK_FORMAT_3_COMMENT_3 = "task123 comment#44556677";
    private final String TASK_FORMAT_4_COMMENT_3 = "task #123 comment#44556677";
    private final String BUG_FORMAT_1_COMMENT_3 = "bug# 123 comment#44556677";
    private final String BUG_FORMAT_2_COMMENT_3 = "bug # 123 comment#44556677";
    private final String BUG_FORMAT_3_COMMENT_3 = "bug123 comment#44556677";
    private final String BUG_FORMAT_4_COMMENT_3 = "bug #123 comment#44556677";
    private final String TASK_FORMAT_1_COMMENT_4 = "task#123 comment # 44556677";
    private final String TASK_FORMAT_2_COMMENT_4 = "task# 123 comment # 44556677";
    private final String TASK_FORMAT_3_COMMENT_4 = "task123 comment # 44556677";
    private final String TASK_FORMAT_4_COMMENT_4 = "task #123 comment # 44556677";
    private final String BUG_FORMAT_1_COMMENT_4 = "bug# 123 comment # 44556677";
    private final String BUG_FORMAT_2_COMMENT_4 = "bug # 123 comment # 44556677";
    private final String BUG_FORMAT_3_COMMENT_4 = "bug123 comment # 44556677";
    private final String BUG_FORMAT_4_COMMENT_4 = "bug #123 comment # 44556677";
    private final String COMMENT_1 = "comment#44556677";
    private final String COMMENT_2 = "comment #44556677";
    private final String COMMENT_3 = "comment # 44556677";
    private final String COMMENT_4 = "comment# 44556677";
    private final String COMMENT_5 = "comment 44556677";
    private TaskHyperlinkDetector detector;
    private TaskRepository repository1;
    private TaskRepository repository2;
    private TextViewer viewer;
    private String[] commentFormats;
    private String[] bugFormats;
    private String[] bugCommentFormats;
    private TaskRepositoryManager repositoryManager;
    private Shell shell;
    protected TaskRepository activeRepository;
    protected ITask task;

    protected void setUp() throws Exception {
        super.setUp();
        this.detector = new TaskHyperlinkDetector();
        this.repository1 = new TaskRepository("bugzilla", "repository_url1");
        this.repository2 = new TaskRepository("bugzilla", "repository_url2");
        this.task = TasksUi.getRepositoryModel().createTask(this.repository1, "123");
        this.detector.setContext(new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (adapter == TaskRepository.class) {
                    return BugzillaTaskHyperlinkDetectorTest.this.activeRepository;
                }
                if (adapter == ITask.class) {
                    return BugzillaTaskHyperlinkDetectorTest.this.task;
                }
                return null;
            }
        });
        this.setRepository(this.repository1);
        this.shell = new Shell();
        this.viewer = new TextViewer((Composite)this.shell, 0);
        this.repositoryManager = TasksUiPlugin.getRepositoryManager();
        this.repositoryManager.clearRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
        this.commentFormats = new String[]{"comment#44556677", "comment #44556677", "comment # 44556677", "comment# 44556677", "comment 44556677"};
        this.bugFormats = new String[]{"task#123", "task# 123", "task123", "task #123", "bug# 123", "bug # 123", "bug123", "bug #123"};
        this.bugCommentFormats = new String[]{"task#123 comment #44556677", "task# 123 comment #44556677", "task123 comment #44556677", "task #123 comment #44556677", "bug# 123 comment #44556677", "bug # 123 comment #44556677", "bug123 comment #44556677", "bug #123 comment #44556677", "task#123 comment#44556677", "task# 123 comment#44556677", "task123 comment#44556677", "task #123 comment#44556677", "bug# 123 comment#44556677", "bug # 123 comment#44556677", "bug123 comment#44556677", "bug #123 comment#44556677", "task#123 comment # 44556677", "task# 123 comment # 44556677", "task123 comment # 44556677", "task #123 comment # 44556677", "bug# 123 comment # 44556677", "bug # 123 comment # 44556677", "bug123 comment # 44556677", "bug #123 comment # 44556677"};
    }

    private void setRepository(TaskRepository repository) {
        this.activeRepository = repository;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.detector.dispose();
        this.repositoryManager.clearRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
        this.shell.dispose();
    }

    public void testBeginningWithSpecialChars() {
        Object comment;
        TaskHyperlink taskLink;
        IHyperlink[] links;
        Region region;
        String testString;
        String format;
        String[] stringArray = this.bugFormats;
        int n = this.bugFormats.length;
        int n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "First line\n:" + format + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNull((Object)comment);
            ++n2;
        }
        stringArray = this.bugCommentFormats;
        n = this.bugCommentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "First line\n:" + format + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
        stringArray = this.commentFormats;
        n = this.commentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "First line\n:" + format + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
    }

    public void testBeginningOfSecondLine() {
        Object comment;
        TaskHyperlink taskLink;
        IHyperlink[] links;
        Region region;
        String testString;
        String format;
        String[] stringArray = this.bugFormats;
        int n = this.bugFormats.length;
        int n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "First line\n" + format + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNull((Object)comment);
            ++n2;
        }
        stringArray = this.bugCommentFormats;
        n = this.bugCommentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "First line\n" + format + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
        stringArray = this.commentFormats;
        n = this.commentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "First line\n" + format + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
    }

    public void testBeginningOfSecondLineWithisWhitespace() {
        Object comment;
        TaskHyperlink taskLink;
        IHyperlink[] links;
        Region region;
        String testString;
        String format;
        String[] stringArray = this.bugFormats;
        int n = this.bugFormats.length;
        int n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "First line\n \t " + format + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNull((Object)comment);
            ++n2;
        }
        stringArray = this.bugCommentFormats;
        n = this.bugCommentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "First line\n \t " + format + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((String)format, (Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
        stringArray = this.commentFormats;
        n = this.commentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "First line\n \t " + format + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
    }

    public void testBeginning() {
        Object comment;
        TaskHyperlink taskLink;
        IHyperlink[] links;
        Region region;
        String testString;
        String format;
        String[] stringArray = this.bugFormats;
        int n = this.bugFormats.length;
        int n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = String.valueOf(format) + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNull((Object)comment);
            ++n2;
        }
        stringArray = this.bugCommentFormats;
        n = this.bugCommentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = String.valueOf(format) + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
        stringArray = this.commentFormats;
        n = this.commentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = String.valueOf(format) + " is at the beginning";
            this.viewer.setDocument((IDocument)new Document(testString));
            region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
    }

    public void testEnd() {
        Object comment;
        TaskHyperlink taskLink;
        IHyperlink[] links;
        Region region;
        int i;
        String testString;
        String format;
        String[] stringArray = this.bugFormats;
        int n = this.bugFormats.length;
        int n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "is ends with " + format;
            this.viewer.setDocument((IDocument)new Document(testString));
            i = testString.indexOf(format);
            region = new Region(i, testString.length() - i);
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNull((Object)comment);
            ++n2;
        }
        stringArray = this.bugCommentFormats;
        n = this.bugCommentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "is ends with " + format;
            this.viewer.setDocument((IDocument)new Document(testString));
            i = testString.indexOf(format);
            region = new Region(i, testString.length() - i);
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
        stringArray = this.commentFormats;
        n = this.commentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "is ends with " + format;
            this.viewer.setDocument((IDocument)new Document(testString));
            Region region2 = new Region(0, testString.length());
            IHyperlink[] links2 = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region2, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links2);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links2.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links2[0] instanceof TaskHyperlink));
            TaskHyperlink taskLink2 = (TaskHyperlink)links2[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink2.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink2.getHyperlinkRegion().getOffset());
            Object comment2 = taskLink2.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment2);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment2);
            ++n2;
        }
    }

    public void testMiddle() {
        Object comment;
        TaskHyperlink taskLink;
        IHyperlink[] links;
        String testString;
        String format;
        String[] stringArray = this.bugFormats;
        int n = this.bugFormats.length;
        int n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "is a " + format + " in the middle";
            this.viewer.setDocument((IDocument)new Document(testString));
            int i = testString.indexOf(format);
            Region region = new Region(i, testString.length() - i);
            IHyperlink[] links2 = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links2);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links2.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links2[0] instanceof TaskHyperlink));
            TaskHyperlink taskLink2 = (TaskHyperlink)links2[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink2.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink2.getHyperlinkRegion().getOffset());
            Object comment2 = taskLink2.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNull((Object)comment2);
            ++n2;
        }
        stringArray = this.bugCommentFormats;
        n = this.bugCommentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "is a " + format + " in the middle";
            this.viewer.setDocument((IDocument)new Document(testString));
            Region region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
        stringArray = this.commentFormats;
        n = this.commentFormats.length;
        n2 = 0;
        while (n2 < n) {
            format = stringArray[n2];
            testString = "is a " + format + " in the middle";
            this.viewer.setDocument((IDocument)new Document(testString));
            Region region = new Region(0, testString.length());
            links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
            taskLink = (TaskHyperlink)links[0];
            BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"123", (String)taskLink.getTaskId());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(format), (int)taskLink.getHyperlinkRegion().getOffset());
            comment = taskLink.getSelection();
            BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)comment);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)"task.common.comment-44556677", (Object)comment);
            ++n2;
        }
    }

    public void testTwoOnSingleLine() {
        String testString = "is a bug# 123 in the middle and at the end bug# 2";
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(0, testString.length());
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)2, (int)links.length);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf("bug# 123"), (int)links[0].getHyperlinkRegion().getOffset());
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf("bug# 2"), (int)links[1].getHyperlinkRegion().getOffset());
    }

    public void testMultiLine() {
        String testString = "is a the first line\n this is the second which ends with a bug, bug# 2";
        this.viewer.setDocument((IDocument)new Document(testString));
        int i = testString.indexOf("bug# 2");
        Region region = new Region(i, testString.length() - i);
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)i, (int)links[0].getHyperlinkRegion().getOffset());
    }

    public void testDuplicate() {
        String testString = "*** This bug has been marked as a duplicate of 112233 ***";
        this.viewer.setDocument((IDocument)new Document(testString));
        int i = testString.indexOf(DUPLICATE);
        Region region = new Region(i, testString.length() - i);
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(DUPLICATE), (int)links[0].getHyperlinkRegion().getOffset());
    }

    public void testNoRepositoryInViewNoRepositoryInManager() {
        String testString = "bug 123";
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(0, testString.length());
        this.setRepository(null);
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, true);
        BugzillaTaskHyperlinkDetectorTest.assertNull((Object)links);
    }

    public void testRepositoryInViewNoRepositoryInManager() {
        String testString = "bug 123";
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(0, testString.length());
        this.setRepository(this.repository1);
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, true);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
        BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)((TaskHyperlink)links[0]).getRepository(), (Object)this.repository1);
    }

    public void testNoRepositoryInViewOneRepositoryInManager() {
        String testString = "bug 123";
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(0, testString.length());
        this.setRepository(null);
        this.repositoryManager.addRepository(this.repository1);
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, true);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
        BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)((TaskHyperlink)links[0]).getRepository(), (Object)this.repository1);
    }

    public void testRepositoryInViewOneRepositoryInManager() {
        String testString = "bug 123";
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(0, testString.length());
        this.setRepository(this.repository1);
        this.repositoryManager.addRepository(this.repository1);
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, true);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
        BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)((TaskHyperlink)links[0]).getRepository(), (Object)this.repository1);
    }

    public void testNoRepositoryInViewTwoRepositoryInManager() {
        String testString = "bug 123";
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(0, testString.length());
        this.setRepository(null);
        this.repositoryManager.addRepository(this.repository1);
        this.repositoryManager.addRepository(this.repository2);
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, true);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)2, (int)links.length);
        BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
        BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[1] instanceof TaskHyperlink));
        if (((TaskHyperlink)links[0]).getRepository() == this.repository1) {
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)((TaskHyperlink)links[1]).getRepository(), (Object)this.repository2);
        } else {
            BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)((TaskHyperlink)links[0]).getRepository(), (Object)this.repository2);
        }
    }

    public void testRepositoryInViewTwoRepositoryInManager() {
        String testString = "bug 123";
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(0, testString.length());
        this.setRepository(this.repository1);
        this.repositoryManager.addRepository(this.repository1);
        this.repositoryManager.addRepository(this.repository2);
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, true);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
        BugzillaTaskHyperlinkDetectorTest.assertEquals((Object)((TaskHyperlink)links[0]).getRepository(), (Object)this.repository1);
    }

    public void testMatchMultipleEmptyRegion() {
        String testString = "bug 123 bug 345";
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(10, 0);
        this.setRepository(this.repository1);
        this.repositoryManager.addRepository(this.repository1);
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, true);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
        BugzillaTaskHyperlinkDetectorTest.assertTrue((boolean)(links[0] instanceof TaskHyperlink));
        BugzillaTaskHyperlinkDetectorTest.assertEquals((String)"345", (String)((TaskHyperlink)links[0]).getTaskId());
    }

    public void testAttachmentOld() {
        String testString = ATTACHMENT_OLD;
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(0, testString.length());
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        if (PlatformUiUtil.supportsMultipleHyperlinkPresenter()) {
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)2, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(ATTACHMENT_OLD), (int)links[0].getHyperlinkRegion().getOffset());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(ATTACHMENT_OLD), (int)links[1].getHyperlinkRegion().getOffset());
        } else {
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(ATTACHMENT_OLD), (int)links[0].getHyperlinkRegion().getOffset());
        }
    }

    public void testAttachmentNew() {
        String testString = ATTACHMENT_NEW;
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(0, testString.length());
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        if (PlatformUiUtil.supportsMultipleHyperlinkPresenter()) {
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)2, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(ATTACHMENT_NEW), (int)links[0].getHyperlinkRegion().getOffset());
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(ATTACHMENT_NEW), (int)links[1].getHyperlinkRegion().getOffset());
        } else {
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)1, (int)links.length);
            BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf(ATTACHMENT_NEW), (int)links[0].getHyperlinkRegion().getOffset());
        }
    }

    public void testCommentLotsOfWhitespace() {
        String testString = "bug 123     d bug 245 comment 1";
        this.viewer.setDocument((IDocument)new Document(testString));
        Region region = new Region(0, testString.length());
        IHyperlink[] links = this.detector.detectHyperlinks((ITextViewer)this.viewer, (IRegion)region, false);
        BugzillaTaskHyperlinkDetectorTest.assertNotNull((Object)links);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)2, (int)links.length);
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf("bug 123"), (int)links[0].getHyperlinkRegion().getOffset());
        BugzillaTaskHyperlinkDetectorTest.assertEquals((int)testString.indexOf("bug 245 comment 1"), (int)links[1].getHyperlinkRegion().getOffset());
    }
}

