/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.core;

import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import org.eclipse.mylyn.commons.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.internal.commons.core.Html2TextReader;

public class HtmlUtil {
    public static String toText(String htmlText) throws IOException {
        int c;
        Html2TextReader reader = new Html2TextReader(new StringReader(htmlText));
        StringBuffer sb = new StringBuffer(htmlText.length());
        while ((c = reader.read()) != -1) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String getTextContent(HtmlStreamTokenizer tokenizer) throws IOException, ParseException {
        StringBuilder sb = new StringBuilder();
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TEXT) {
                sb.append(token.toString().trim());
                sb.append(" ");
            } else if (token.getType() != HtmlStreamTokenizer.Token.COMMENT) break;
            token = tokenizer.nextToken();
        }
        return sb.toString().trim();
    }
}

