/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.core.parser.html;

import java.util.HashSet;
import java.util.List;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.DocumentProcessor;
import org.eclipse.mylyn.internal.wikitext.core.parser.html.Html;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

class WhitespaceCleanupProcessor
extends DocumentProcessor {
    WhitespaceCleanupProcessor() {
    }

    public void process(Document document) {
        Element body = document.body();
        HashSet<Node> affectedParents = new HashSet<Node>();
        for (Element element : body.getAllElements()) {
            if (Html.isWhitespacePreserve(element)) continue;
            List children = element.childNodes();
            if (!children.isEmpty()) {
                Node lastChild;
                Node firstChild = (Node)children.get(0);
                if (firstChild instanceof TextNode) {
                    TextNode textNode = (TextNode)firstChild;
                    String text = textNode.getWholeText();
                    int nonWhitespaceIndex = WhitespaceCleanupProcessor.firstIndexOfNonWhitespace(text);
                    if (nonWhitespaceIndex > 0) {
                        affectedParents.add(textNode.parent());
                        textNode.splitText(nonWhitespaceIndex);
                        textNode.remove();
                        this.computeBeforeTarget(element).before((Node)textNode);
                        affectedParents.add(textNode.parent());
                    } else if (nonWhitespaceIndex == -1) {
                        textNode.remove();
                        this.computeAfterTarget(element).after((Node)textNode);
                        affectedParents.add(textNode.parent());
                    }
                }
                if (!(children = element.childNodes()).isEmpty() && (lastChild = (Node)children.get(children.size() - 1)) instanceof TextNode) {
                    TextNode textNode = (TextNode)lastChild;
                    String text = textNode.getWholeText();
                    int lastNonWhitespaceIndex = WhitespaceCleanupProcessor.lastIndexOfNonWhitespace(text);
                    if (lastNonWhitespaceIndex < 0) {
                        textNode.remove();
                        this.computeAfterTarget(element).after((Node)textNode);
                        affectedParents.add(textNode.parent());
                    } else if (lastNonWhitespaceIndex < text.length() - 1) {
                        affectedParents.add(textNode.parent());
                        textNode.splitText(lastNonWhitespaceIndex + 1);
                        textNode = (TextNode)textNode.nextSibling();
                        textNode.remove();
                        this.computeAfterTarget(element).after((Node)textNode);
                        affectedParents.add(textNode.parent());
                    }
                }
            }
            if (affectedParents.isEmpty()) continue;
            for (Node parent : affectedParents) {
                if (!(parent instanceof Element)) continue;
                WhitespaceCleanupProcessor.normalizeTextNodes((Element)parent);
            }
            affectedParents.clear();
        }
    }

    private Element computeAfterTarget(Element element) {
        List elementParentChildNodes;
        if (!(element.parent() == null || element.nodeName().equalsIgnoreCase("html") || (elementParentChildNodes = element.parent().childNodes()).size() != 1 && elementParentChildNodes.get(elementParentChildNodes.size() - 1) != element)) {
            return this.computeAfterTarget(element.parent());
        }
        return element;
    }

    private Element computeBeforeTarget(Element element) {
        List elementParentChildNodes;
        if (!(element.parent() == null || element.parent().nodeName().equalsIgnoreCase("html") || (elementParentChildNodes = element.parent().childNodes()).size() != 1 && elementParentChildNodes.get(0) != element)) {
            return this.computeBeforeTarget(element.parent());
        }
        return element;
    }

    private static int lastIndexOfNonWhitespace(String text) {
        int i = text.length() - 1;
        while (i > -1) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return i;
            }
            --i;
        }
        return i;
    }

    private static int firstIndexOfNonWhitespace(String text) {
        int i = 0;
        while (i < text.length()) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

