/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb;

import com.google.gerrit.reviewdb.Account;
import com.google.gerrit.reviewdb.AccountGroup;
import com.google.gerrit.reviewdb.AccountGroupMember;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.CompoundKey;
import java.sql.Timestamp;

public final class AccountGroupMemberAudit {
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2)
    protected Account.Id addedBy;
    @Column(id=3, notNull=false)
    protected Account.Id removedBy;
    @Column(id=4, notNull=false)
    protected Timestamp removedOn;

    protected AccountGroupMemberAudit() {
    }

    public AccountGroupMemberAudit(AccountGroupMember m, Account.Id adder) {
        Account.Id who = m.getAccountId();
        AccountGroup.Id group = m.getAccountGroupId();
        this.key = new Key(who, group, AccountGroupMemberAudit.now());
        this.addedBy = adder;
    }

    public Key getKey() {
        return this.key;
    }

    public boolean isActive() {
        return this.removedOn == null;
    }

    public void removed(Account.Id deleter) {
        this.removedBy = deleter;
        this.removedOn = AccountGroupMemberAudit.now();
    }

    public void removedLegacy() {
        this.removedBy = this.addedBy;
        this.removedOn = this.key.addedOn;
    }

    private static Timestamp now() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static class Key
    extends CompoundKey<Account.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Account.Id accountId;
        @Column(id=2)
        protected AccountGroup.Id groupId;
        @Column(id=3)
        protected Timestamp addedOn;

        protected Key() {
            this.accountId = new Account.Id();
            this.groupId = new AccountGroup.Id();
        }

        public Key(Account.Id a, AccountGroup.Id g, Timestamp t) {
            this.accountId = a;
            this.groupId = g;
            this.addedOn = t;
        }

        public Account.Id getParentKey() {
            return this.accountId;
        }

        public com.google.gwtorm.client.Key<?>[] members() {
            return new com.google.gwtorm.client.Key[]{this.groupId};
        }
    }
}

