/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.client;

import com.google.gerrit.common.auth.SignInMode;
import com.google.gerrit.common.auth.openid.DiscoveryResult;
import com.google.gerrit.common.auth.userpass.LoginResult;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.CoreUtil;
import org.eclipse.mylyn.commons.net.AbstractWebLocation;
import org.eclipse.mylyn.commons.net.AuthenticationCredentials;
import org.eclipse.mylyn.commons.net.AuthenticationType;
import org.eclipse.mylyn.commons.net.UnsupportedRequestException;
import org.eclipse.mylyn.commons.net.WebUtil;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHtmlProcessor;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritHttpException;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritLoginException;
import org.eclipse.mylyn.internal.gerrit.core.client.IOpenIdLocation;
import org.eclipse.mylyn.internal.gerrit.core.client.JSonSupport;
import org.eclipse.mylyn.internal.gerrit.core.client.OpenIdAuthenticationRequest;
import org.eclipse.mylyn.internal.gerrit.core.client.OpenIdAuthenticationResponse;

public class GerritHttpClient {
    private static final Object LOGIN_COOKIE_NAME = "GerritAccount";
    private static final String LOGIN_URL = "/login/mine";
    private static final String BECOME_URL = "/become";
    private HostConfiguration hostConfiguration;
    private final HttpClient httpClient;
    private int id = 1;
    private final AbstractWebLocation location;
    private volatile Cookie xsrfCookie;
    private volatile String xsrfKey;
    private volatile boolean obtainedXsrfKey;

    public GerritHttpClient(AbstractWebLocation location) {
        Assert.isNotNull((Object)location, (String)"Location must be not null.");
        this.location = location;
        this.httpClient = new HttpClient(WebUtil.getConnectionManager());
    }

    public synchronized int getId() {
        return this.id++;
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    public synchronized String getXsrfKey() {
        if (this.xsrfKey != null) {
            return this.xsrfKey;
        }
        return this.xsrfCookie != null ? this.xsrfCookie.getValue() : null;
    }

    public synchronized void setXsrfKey(String xsrfKey) {
        this.xsrfKey = xsrfKey;
        this.obtainedXsrfKey = true;
    }

    public String postJsonRequest(String serviceUri, JsonEntity entity, IProgressMonitor monitor) throws IOException, GerritException {
        Assert.isNotNull((Object)serviceUri, (String)"Service URI must be not null.");
        Assert.isNotNull((Object)entity, (String)"JSON entity must be not null.");
        return this.execute(new JsonRequest(serviceUri, entity), monitor);
    }

    public <T> T execute(Request<T> request, IProgressMonitor monitor) throws IOException, GerritException {
        String openIdProvider = this.getOpenIdProvider();
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        int attempt = 0;
        while (attempt < 2) {
            if (this.needsAuthentication()) {
                AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
                if (openIdProvider != null || credentials != null) {
                    this.authenticate(openIdProvider, monitor);
                }
            }
            if (!this.obtainedXsrfKey) {
                this.updateXsrfKey(monitor);
            }
            HttpMethodBase method = request.createMethod();
            try {
                WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            }
            catch (IOException e) {
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                throw e;
            }
            catch (RuntimeException e) {
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                throw e;
            }
            int code = method.getStatusCode();
            if (code == 200) {
                try {
                    T t = request.process(method);
                    return t;
                }
                finally {
                    WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
                }
            }
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            if (code != 401 && code != 403) {
                throw new GerritHttpException(code);
            }
            this.authenticate(openIdProvider, monitor);
            ++attempt;
        }
        throw new GerritLoginException();
    }

    private void updateXsrfKey(IProgressMonitor monitor) throws IOException {
        block6: {
            String repositoryUrl = String.valueOf(this.getUrl()) + "/";
            GetMethod method = new GetMethod(WebUtil.getRequestPath((String)repositoryUrl));
            method.setFollowRedirects(false);
            try {
                int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
                if (code != 200) break block6;
                InputStream in = WebUtil.getResponseBodyAsStream((HttpMethodBase)method, (IProgressMonitor)monitor);
                try {
                    GerritHtmlProcessor processor = new GerritHtmlProcessor();
                    processor.parse(in, method.getResponseCharSet());
                    this.setXsrfKey(processor.getXsrfKey());
                }
                finally {
                    in.close();
                }
            }
            finally {
                WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            }
        }
    }

    GetMethod getRequest(String serviceUri, IProgressMonitor monitor) throws IOException {
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
        GetMethod method = new GetMethod(String.valueOf(this.getUrl()) + serviceUri);
        try {
            WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            return method;
        }
        catch (IOException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw e;
        }
        catch (RuntimeException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw e;
        }
    }

    String getUrl() {
        String url = this.location.getUrl();
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    private void authenticate(String openIdProvider, IProgressMonitor monitor) throws GerritException, IOException {
        block5: {
            while (true) {
                int code;
                AuthenticationCredentials credentials = this.location.getCredentials(AuthenticationType.REPOSITORY);
                if (openIdProvider != null) {
                    code = this.authenticateOpenIdService(openIdProvider, credentials, monitor);
                    if (code == -1) {
                        continue;
                    }
                } else {
                    if (credentials == null) break;
                    code = this.authenticateForm(credentials, monitor);
                    if (code == -1 || code == 404 && ((code = this.authenticateUserPassService(credentials, monitor)) == -1 || code == 404 && (code = this.authenticateDevelopmentMode(credentials, monitor)) == -1)) {
                        continue;
                    }
                }
                break block5;
                break;
            }
            throw new GerritLoginException();
        }
        this.validateAuthenticationState(this.httpClient);
    }

    private String getOpenIdProvider() {
        if (this.location instanceof IOpenIdLocation) {
            return ((IOpenIdLocation)this.location).getProviderUrl();
        }
        return null;
    }

    private int authenticateOpenIdService(String openIdProvider, AuthenticationCredentials credentials, IProgressMonitor monitor) throws IOException, GerritException {
        JSonSupport json = new JSonSupport();
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(openIdProvider);
        args.add(SignInMode.SIGN_IN);
        args.add(Boolean.TRUE);
        args.add("");
        final String request = json.createRequest(this.getId(), null, "discover", args);
        JsonEntity entity = new JsonEntity(){

            @Override
            public String getContent() {
                return request;
            }
        };
        OpenIdAuthenticationResponse openIdResponse = null;
        JsonRequest jsonRequest = new JsonRequest("/gerrit/rpc/OpenIdService", entity);
        PostMethod method = jsonRequest.createMethod();
        try {
            int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            if (this.needsReauthentication(code, monitor)) {
                return -1;
            }
            if (code == 200) {
                DiscoveryResult result = (DiscoveryResult)json.parseResponse(jsonRequest.process((HttpMethodBase)method), (Type)((Object)DiscoveryResult.class));
                if (result.status == DiscoveryResult.Status.VALID) {
                    if (this.location instanceof IOpenIdLocation) {
                        String returnUrl = (String)result.providerArgs.get("openid.return_to");
                        OpenIdAuthenticationRequest authenticationRequest = new OpenIdAuthenticationRequest(result.providerUrl, result.providerArgs, returnUrl);
                        authenticationRequest.setAlternateUrl(this.location.getUrl());
                        authenticationRequest.setCookie("GerritAccount");
                        authenticationRequest.setCookieUrl(this.location.getUrl());
                        try {
                            openIdResponse = ((IOpenIdLocation)this.location).requestAuthentication(authenticationRequest, monitor);
                        }
                        catch (UnsupportedRequestException unsupportedRequestException) {
                            throw new GerritLoginException();
                        }
                    }
                } else {
                    throw new GerritException("Invalid OpenID provider");
                }
            }
            if (openIdResponse == null) {
                int n = code;
                return n;
            }
        }
        finally {
            method.releaseConnection();
        }
        if (openIdResponse.getCookieValue() != null) {
            URL url = new URL(this.location.getUrl());
            boolean isSecure = "https".equals(url.getProtocol());
            this.setXsrfCookie(new Cookie(url.getHost(), "GerritAccount", openIdResponse.getCookieValue(), url.getPath(), null, isSecure));
            return 307;
        }
        GetMethod validateMethod = new GetMethod(openIdResponse.getResponseUrl());
        try {
            WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)validateMethod, (IProgressMonitor)monitor);
        }
        catch (IOException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw e;
        }
        catch (RuntimeException e) {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
            throw e;
        }
        if (validateMethod.getStatusCode() == 200) {
            return 307;
        }
        return validateMethod.getStatusCode();
    }

    private int authenticateUserPassService(AuthenticationCredentials credentials, IProgressMonitor monitor) throws IOException, GerritException {
        JSonSupport json = new JSonSupport();
        ArrayList<Object> args = new ArrayList<Object>(2);
        args.add(credentials.getUserName());
        args.add(credentials.getPassword());
        final String request = json.createRequest(this.getId(), null, "authenticate", args);
        JsonEntity entity = new JsonEntity(){

            @Override
            public String getContent() {
                return request;
            }
        };
        JsonRequest jsonRequest = new JsonRequest("/gerrit/rpc/UserPassAuthService", entity);
        PostMethod method = jsonRequest.createMethod();
        try {
            int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            if (this.needsReauthentication(code, monitor)) {
                return -1;
            }
            if (code == 200) {
                LoginResult result = (LoginResult)json.parseResponse(jsonRequest.process((HttpMethodBase)method), (Type)((Object)LoginResult.class));
                if (result.success) {
                    return 307;
                }
                this.requestCredentials(monitor, AuthenticationType.REPOSITORY);
                return -1;
            }
            int n = code;
            return n;
        }
        finally {
            method.releaseConnection();
        }
    }

    private int authenticateDevelopmentMode(AuthenticationCredentials credentials, IProgressMonitor monitor) throws IOException, GerritException {
        String key;
        if (credentials.getUserName().contains("@")) {
            key = "preferred_email";
        } else {
            try {
                Long.parseLong(credentials.getUserName());
                key = "account_id";
            }
            catch (NumberFormatException numberFormatException) {
                key = "user_name";
            }
        }
        String repositoryUrl = this.getUrl();
        GetMethod method = new GetMethod(WebUtil.getRequestPath((String)(String.valueOf(repositoryUrl) + BECOME_URL + "?" + key + "=" + credentials.getUserName())));
        method.setFollowRedirects(false);
        try {
            int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            if (this.needsReauthentication(code, monitor)) {
                return -1;
            }
            if (code == 200) {
                int n = code;
                return n;
            }
            if (code != 404 && code != 302 && code != 302) {
                throw new GerritHttpException(code);
            }
            int n = code;
            return n;
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    private int authenticateForm(AuthenticationCredentials credentials, IProgressMonitor monitor) throws IOException, GerritException {
        String repositoryUrl = this.getUrl();
        AuthScope authScope = new AuthScope(WebUtil.getHost((String)repositoryUrl), WebUtil.getPort((String)repositoryUrl), null, AuthScope.ANY_SCHEME);
        Credentials httpCredentials = WebUtil.getHttpClientCredentials((AuthenticationCredentials)credentials, (String)WebUtil.getHost((String)repositoryUrl));
        this.httpClient.getState().setCredentials(authScope, httpCredentials);
        GetMethod method = new GetMethod(WebUtil.getRequestPath((String)(String.valueOf(repositoryUrl) + LOGIN_URL)));
        method.setFollowRedirects(false);
        try {
            int code = WebUtil.execute((HttpClient)this.httpClient, (HostConfiguration)this.hostConfiguration, (HttpMethod)method, (IProgressMonitor)monitor);
            if (this.needsReauthentication(code, monitor)) {
                return -1;
            }
            if (code == 302) {
                Header locationHeader = method.getResponseHeader("Location");
                if (locationHeader != null && locationHeader.getValue().endsWith("SignInFailure,SIGN_IN,Session cookie not available.")) {
                    return 404;
                }
            } else if (code != 404) {
                throw new GerritHttpException(code);
            }
            int n = code;
            return n;
        }
        finally {
            WebUtil.releaseConnection((HttpMethodBase)method, (IProgressMonitor)monitor);
        }
    }

    private synchronized boolean needsAuthentication() {
        return this.xsrfCookie == null || this.xsrfCookie.isExpired();
    }

    private boolean needsReauthentication(int code, IProgressMonitor monitor) throws IOException, GerritLoginException {
        AuthenticationType authenticationType;
        if (code == 401 || code == 403) {
            authenticationType = AuthenticationType.REPOSITORY;
        } else if (code == 407) {
            authenticationType = AuthenticationType.PROXY;
        } else {
            return false;
        }
        this.requestCredentials(monitor, authenticationType);
        return true;
    }

    void requestCredentials(IProgressMonitor monitor, AuthenticationType authenticationType) throws GerritLoginException {
        try {
            this.location.requestCredentials(authenticationType, null, monitor);
        }
        catch (UnsupportedRequestException unsupportedRequestException) {
            throw new GerritLoginException();
        }
        this.hostConfiguration = WebUtil.createHostConfiguration((HttpClient)this.httpClient, (AbstractWebLocation)this.location, (IProgressMonitor)monitor);
    }

    protected void validateAuthenticationState(HttpClient httpClient) throws GerritLoginException {
        Cookie[] cookies;
        Cookie[] cookieArray = cookies = httpClient.getState().getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (LOGIN_COOKIE_NAME.equals(cookie.getName())) {
                this.setXsrfCookie(cookie);
                return;
            }
            ++n2;
        }
        if (CoreUtil.TEST_MODE) {
            System.err.println(" Authentication failed: " + httpClient.getState());
        }
        throw new GerritLoginException();
    }

    protected void sessionChanged(Cookie cookie) {
    }

    public boolean isAnonymous() {
        return this.getLocation().getCredentials(AuthenticationType.REPOSITORY) == null && this.getOpenIdProvider() == null;
    }

    public Cookie getXsrfCookie() {
        return this.xsrfCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setXsrfCookie(Cookie xsrfCookie) {
        Cookie oldCookie;
        GerritHttpClient gerritHttpClient = this;
        synchronized (gerritHttpClient) {
            oldCookie = this.xsrfCookie;
            this.xsrfCookie = xsrfCookie;
            if (xsrfCookie == null) {
                this.obtainedXsrfKey = false;
            }
        }
        if (xsrfCookie != null) {
            if (!xsrfCookie.equals((Object)oldCookie)) {
                this.httpClient.getState().addCookie(xsrfCookie);
            }
        } else {
            this.httpClient.getState().clear();
        }
        this.sessionChanged(xsrfCookie);
    }

    public static abstract class JsonEntity {
        public abstract String getContent();
    }

    private class JsonRequest
    extends Request<String> {
        private final String serviceUri;
        private final JsonEntity entity;

        public JsonRequest(String serviceUri, JsonEntity entity) {
            this.serviceUri = serviceUri;
            this.entity = entity;
        }

        public PostMethod createMethod() throws IOException {
            PostMethod method = new PostMethod(String.valueOf(GerritHttpClient.this.getUrl()) + this.serviceUri);
            method.setRequestHeader("Content-Type", "application/json; charset=utf-8");
            method.setRequestHeader("Accept", "application/json");
            StringRequestEntity requestEntity = new StringRequestEntity(this.entity.getContent(), "application/json", null);
            method.setRequestEntity((RequestEntity)requestEntity);
            return method;
        }

        @Override
        public String process(HttpMethodBase method) throws IOException {
            return method.getResponseBodyAsString();
        }
    }

    public static abstract class Request<T> {
        public abstract HttpMethodBase createMethod() throws IOException;

        public abstract T process(HttpMethodBase var1) throws IOException;
    }
}

