/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests;

import junit.framework.TestCase;
import org.eclipse.mylyn.commons.ui.ClipboardCopier;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryManager;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;
import org.eclipse.mylyn.tasks.tests.connector.MockTask;
import org.eclipse.mylyn.tasks.ui.TasksUi;

public class CopyDetailsActionTest
extends TestCase {
    public void testGetTextForTask() {
        MockTask task = new MockTask("123");
        task.setSummary("abc");
        task.setTaskKey("123");
        String text = CopyTaskDetailsAction.getTextForTask((Object)((Object)task));
        CopyDetailsActionTest.assertEquals((String)"123: abc", (String)text);
        task.setTaskKey(null);
        CopyDetailsActionTest.assertEquals((String)"abc", (String)CopyTaskDetailsAction.getTextForTask((Object)((Object)task)));
    }

    public void testGetSummaryAndUrl() {
        MockTask task = new MockTask("321");
        task.setSummary("s321");
        task.setTaskKey("321");
        MockRepositoryConnector connector = new MockRepositoryConnector(){

            public String getTaskUrl(String repositoryUrl, String taskId) {
                return "http://321.com";
            }
        };
        AbstractRepositoryConnector oldConnector = TasksUi.getRepositoryManager().getRepositoryConnector("mock");
        try {
            ((TaskRepositoryManager)TasksUi.getRepositoryManager()).addRepositoryConnector((AbstractRepositoryConnector)connector);
            CopyDetailsActionTest.assertEquals((String)("321: s321" + ClipboardCopier.LINE_SEPARATOR + "http://321.com"), (String)CopyTaskDetailsAction.getTextForTask((Object)((Object)task), (CopyTaskDetailsAction.Mode)CopyTaskDetailsAction.Mode.SUMMARY_URL));
        }
        finally {
            if (oldConnector != null) {
                ((TaskRepositoryManager)TasksUi.getRepositoryManager()).addRepositoryConnector(oldConnector);
            }
        }
    }
}

