/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.tests.connector;

import java.util.Date;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.ITaskMapping;
import org.eclipse.mylyn.tasks.core.RepositoryResponse;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskAttributeMapper;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskMapper;
import org.eclipse.mylyn.tasks.tests.connector.MockRepositoryConnector;

public class MockRepositoryConnectorWithTaskDataHandler
extends MockRepositoryConnector {
    protected final AtomicInteger idSeed = new AtomicInteger(9000);

    public boolean hasTaskChanged(TaskRepository taskRepository, ITask task, TaskData taskData) {
        TaskMapper taskMapping = this.getTaskMapping(taskData);
        Date modificationDate = taskMapping.getModificationDate();
        return modificationDate != null && !modificationDate.equals(task.getModificationDate());
    }

    public TaskMapper getTaskMapping(TaskData taskData) {
        return new TaskMapper(taskData, true);
    }

    public void updateTaskFromTaskData(TaskRepository taskRepository, ITask task, TaskData taskData) {
        Date originalModificationDate = task.getModificationDate();
        TaskMapper taskMapping = this.getTaskMapping(taskData);
        taskMapping.applyTo(task);
        if (taskData.isPartial()) {
            task.setModificationDate(originalModificationDate);
        }
    }

    public AbstractTaskDataHandler getTaskDataHandler() {
        return new AbstractTaskDataHandler(){

            public RepositoryResponse postTaskData(TaskRepository repository, TaskData taskData, Set<TaskAttribute> oldAttributes, IProgressMonitor monitor) throws CoreException {
                if (taskData.getTaskId() == null || taskData.getTaskId().length() == 0) {
                    return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, String.valueOf(MockRepositoryConnectorWithTaskDataHandler.this.idSeed.incrementAndGet()));
                }
                return new RepositoryResponse(RepositoryResponse.ResponseKind.TASK_UPDATED, taskData.getTaskId());
            }

            public boolean initializeTaskData(TaskRepository repository, TaskData data, ITaskMapping initializationData, IProgressMonitor monitor) throws CoreException {
                TaskMapper mapper = MockRepositoryConnectorWithTaskDataHandler.this.getTaskMapping(data);
                mapper.setCreationDate(new Date());
                mapper.setDescription("");
                mapper.setModificationDate(mapper.getCreationDate());
                mapper.setOwner("");
                mapper.setProduct("Product1");
                mapper.setReporter("");
                mapper.setStatus("NEW");
                mapper.setSummary("");
                mapper.setTaskKey("");
                return true;
            }

            public TaskAttributeMapper getAttributeMapper(TaskRepository repository) {
                return new TaskAttributeMapper(repository);
            }
        };
    }
}

