/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.annotations;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.mylyn.commons.workbench.forms.CommonFormUtil;
import org.eclipse.mylyn.internal.reviews.ui.IReviewActionListener;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotationHoverInput;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentInformationControl;
import org.eclipse.mylyn.internal.reviews.ui.editors.parts.CommentPart;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CommentPopupDialog
extends PopupDialog
implements IReviewActionListener {
    private static final int MAX_WIDTH = 500;
    private int maxWidth;
    private CommentAnnotationHoverInput annotationInput;
    private FormToolkit toolkit;
    private Composite composite;
    private Label focusLabel;
    private ScrolledComposite scrolledComposite;
    private CommentInformationControl informationControl;
    private static CommentPopupDialog currentPopupDialog;

    public CommentPopupDialog(Shell parent, int shellStyle) {
        super(parent, shellStyle, false, false, false, false, false, null, null);
    }

    protected Control createDialogArea(Composite parent) {
        this.toolkit = new FormToolkit(CommonFormUtil.getSharedColors());
        this.scrolledComposite = new ScrolledComposite(parent, 512);
        this.scrolledComposite.setExpandHorizontal(true);
        this.scrolledComposite.setExpandVertical(true);
        this.toolkit.adapt((Composite)this.scrolledComposite);
        this.composite = this.toolkit.createComposite((Composite)this.scrolledComposite, 0);
        this.composite.setLayout((Layout)new GridLayout());
        this.scrolledComposite.setContent((Control)this.composite);
        return this.scrolledComposite;
    }

    public void dispose() {
        currentPopupDialog = null;
        this.close();
        this.toolkit.dispose();
    }

    public void setFocus() {
        this.getShell().forceFocus();
        if (this.focusLabel != null) {
            this.focusLabel.dispose();
        }
        if (this.composite.getChildren().length > 0) {
            this.composite.getChildren()[0].setFocus();
        }
        Point computeSize = this.composite.computeSize(-1, -1);
        if (computeSize.y > this.scrolledComposite.getSize().y) {
            this.scrolledComposite.setExpandVertical(false);
            this.composite.setSize(computeSize);
        }
    }

    public Point computeSizeHint() {
        int widthHint = 500;
        if (this.maxWidth < widthHint) {
            widthHint = this.maxWidth;
        }
        return this.getShell().computeSize(widthHint, -1, true);
    }

    public void removeFocusListener(FocusListener listener) {
        this.composite.removeFocusListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.composite.addFocusListener(listener);
    }

    public boolean isFocusControl() {
        return this.getShell().getDisplay().getActiveShell() == this.getShell();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public Rectangle getBounds() {
        return this.getShell().getBounds();
    }

    public Rectangle computeTrim() {
        return this.getShell().computeTrim(0, 0, 0, 0);
    }

    public void setSizeConstraints(int newMaxWidth, int newMaxHeight) {
        this.maxWidth = newMaxWidth;
    }

    public void setLocation(Point location) {
        this.getShell().setLocation(location);
    }

    public void setSize(int width, int height) {
        Point computeSize = this.composite.computeSize(-1, -1);
        if (computeSize.x > width) {
            width = computeSize.x;
        }
        this.getShell().setSize(width, height);
    }

    public void setInput(Object input) {
        if (input instanceof CommentAnnotationHoverInput) {
            this.annotationInput = (CommentAnnotationHoverInput)input;
            Control[] controlArray = this.composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.dispose();
                ++n2;
            }
            currentPopupDialog = this;
            for (CommentAnnotation annotation : this.annotationInput.getAnnotations()) {
                CommentPart part = new CommentPart(annotation.getComment(), this.annotationInput.getBehavior());
                part.hookCustomActionRunListener(this);
                Control control = part.createControl(this.composite, this.toolkit);
                this.toolkit.adapt(control, true, true);
            }
            this.composite.setBackground(this.toolkit.getColors().getBackground());
            this.scrolledComposite.layout(true, true);
            this.scrolledComposite.setMinSize(this.composite.computeSize(-1, -1));
        } else {
            input = null;
        }
    }

    @Override
    public void actionAboutToRun(Action action) {
        this.close();
    }

    @Override
    public void actionRan(Action action) {
        this.close();
    }

    public static CommentPopupDialog getCurrentPopupDialog() {
        return currentPopupDialog;
    }

    public void setInformationControl(CommentInformationControl crucibleInformationControl) {
        this.informationControl = crucibleInformationControl;
    }

    public CommentInformationControl getInformationControl() {
        return this.informationControl;
    }
}

