/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.reviews.ui.compare.FileItemNode;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewCompareAnnotationSupport;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;

public class FileItemCompareEditorInput
extends CompareEditorInput {
    private final IFileItem file;
    private final ReviewBehavior behavior;

    public FileItemCompareEditorInput(CompareConfiguration configuration, IFileItem file, ReviewBehavior behavior) {
        super(configuration);
        this.file = file;
        this.behavior = behavior;
        this.setTitle(NLS.bind((String)"Compare {0} {1} and {2}", (Object[])new Object[]{file.getName(), file.getBase().getDescription(), file.getTarget().getDescription()}));
    }

    protected Object prepareInput(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        FileItemNode node = new FileItemNode(this.behavior, this.file, monitor);
        this.getCompareConfiguration().setLabelProvider((ICompareInput)node, node.getLabelProvider());
        return node;
    }

    public Viewer findContentViewer(Viewer oldViewer, ICompareInput input, Composite parent) {
        Viewer contentViewer = super.findContentViewer(oldViewer, input, parent);
        if (input instanceof FileItemNode) {
            ReviewCompareAnnotationSupport support = ReviewCompareAnnotationSupport.getAnnotationSupport(contentViewer);
            support.setReviewItem(((FileItemNode)input).getFileItem(), this.behavior);
        }
        return contentViewer;
    }

    public IFileItem getFile() {
        return this.file;
    }

    protected void contentsCreated() {
        super.contentsCreated();
    }
}

