/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.lang.reflect.Field;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewAnnotationModel;
import org.eclipse.mylyn.internal.reviews.ui.compare.CompareUtil;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewCompareInputListener;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewItemSetCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.swt.widgets.Display;

public class ReviewCompareAnnotationSupport {
    private static String KEY_ANNOTAION_SUPPORT = ReviewItemSetCompareEditorInput.class.getName();
    private ReviewBehavior behavior;
    private final ReviewAnnotationModel leftAnnotationModel = new ReviewAnnotationModel();
    private ReviewCompareInputListener leftViewerListener;
    private final ReviewAnnotationModel rightAnnotationModel = new ReviewAnnotationModel();
    private ReviewCompareInputListener rightViewerListener;

    public static ReviewCompareAnnotationSupport getAnnotationSupport(Viewer contentViewer) {
        ReviewCompareAnnotationSupport support = (ReviewCompareAnnotationSupport)contentViewer.getData(KEY_ANNOTAION_SUPPORT);
        if (support == null) {
            support = new ReviewCompareAnnotationSupport(contentViewer);
            contentViewer.setData(KEY_ANNOTAION_SUPPORT, (Object)support);
        }
        return support;
    }

    public ReviewCompareAnnotationSupport(Viewer contentViewer) {
        this.install(contentViewer);
    }

    public void attachToViewer(TextMergeViewer viewer, MergeSourceViewer fLeft, MergeSourceViewer fRight) {
        if (!this.isListenerFor(this.leftViewerListener, fLeft, this.leftAnnotationModel)) {
            this.leftViewerListener = this.registerInputListener(fLeft, this.leftAnnotationModel);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReviewCompareAnnotationSupport.this.leftViewerListener.forceCustomAnnotationHover();
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching annotation hover", (Throwable)e));
                    }
                }
            });
        }
        if (!this.isListenerFor(this.rightViewerListener, fRight, this.rightAnnotationModel)) {
            this.rightViewerListener = this.registerInputListener(fRight, this.rightAnnotationModel);
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    try {
                        ReviewCompareAnnotationSupport.this.rightViewerListener.forceCustomAnnotationHover();
                    }
                    catch (Exception e) {
                        StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching annotation hover", (Throwable)e));
                    }
                }
            });
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReviewCompareAnnotationSupport other = (ReviewCompareAnnotationSupport)obj;
        if (this.leftAnnotationModel == null ? other.leftAnnotationModel != null : !this.leftAnnotationModel.equals(other.leftAnnotationModel)) {
            return false;
        }
        return !(this.rightAnnotationModel == null ? other.rightAnnotationModel != null : !this.rightAnnotationModel.equals(other.rightAnnotationModel));
    }

    public ReviewBehavior getBehavior() {
        return this.behavior;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.leftAnnotationModel == null ? 0 : this.leftAnnotationModel.hashCode());
        result = 31 * result + (this.rightAnnotationModel == null ? 0 : this.rightAnnotationModel.hashCode());
        return result;
    }

    public void install(Viewer contentViewer) {
        if (contentViewer instanceof TextMergeViewer) {
            TextMergeViewer textMergeViewer = (TextMergeViewer)contentViewer;
            try {
                Class<TextMergeViewer> clazz = TextMergeViewer.class;
                Field declaredField = clazz.getDeclaredField("fLeft");
                declaredField.setAccessible(true);
                MergeSourceViewer fLeft = (MergeSourceViewer)declaredField.get(textMergeViewer);
                declaredField = clazz.getDeclaredField("fRight");
                declaredField.setAccessible(true);
                MergeSourceViewer fRight = (MergeSourceViewer)declaredField.get(textMergeViewer);
                this.leftViewerListener = this.registerInputListener(fLeft, this.leftAnnotationModel);
                this.rightViewerListener = this.registerInputListener(fRight, this.rightAnnotationModel);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.reviews.ui", "Could not initialize annotation model for " + Viewer.class.getName(), t));
            }
        }
    }

    public void setReviewItem(IFileItem item, ReviewBehavior behavior) {
        this.leftAnnotationModel.setItem((IReviewItem)item.getBase(), behavior);
        this.rightAnnotationModel.setItem((IReviewItem)item.getTarget(), behavior);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ReviewCompareAnnotationSupport.this.leftViewerListener.forceCustomAnnotationHover();
                }
                catch (Exception e) {
                    StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching annotation hover", (Throwable)e));
                }
            }
        });
    }

    private boolean isListenerFor(ReviewCompareInputListener listener, MergeSourceViewer viewer, ReviewAnnotationModel annotationModel) {
        if (listener == null) {
            return false;
        }
        return listener.isListenerFor(viewer, annotationModel);
    }

    private ReviewCompareInputListener registerInputListener(MergeSourceViewer sourceViewer, ReviewAnnotationModel annotationModel) {
        ReviewCompareInputListener listener = new ReviewCompareInputListener(sourceViewer, annotationModel);
        SourceViewer viewer = CompareUtil.getSourceViewer(sourceViewer);
        if (viewer != null) {
            viewer.addTextInputListener((ITextInputListener)listener);
        }
        listener.registerContextMenu();
        return listener;
    }
}

