/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.markup;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.mylyn.wikitext.core.parser.markup.Processor;
import org.eclipse.mylyn.wikitext.core.parser.util.Matcher;

public abstract class PatternBasedElementProcessor
extends Processor
implements Matcher {
    protected int lineStartOffset;
    protected int lineEndOffset;
    protected Map<Integer, Group> groupByIndex;

    public void setGroup(int group, String capturedText, int start, int end) {
        if (this.groupByIndex == null) {
            this.groupByIndex = new HashMap<Integer, Group>();
        }
        this.groupByIndex.put(group, new Group(capturedText, start, end));
    }

    public int getLineStartOffset() {
        return this.lineStartOffset;
    }

    public void setLineStartOffset(int lineStartOffset) {
        this.lineStartOffset = lineStartOffset;
    }

    public int getLineEndOffset() {
        return this.lineEndOffset;
    }

    public void setLineEndOffset(int lineEndOffset) {
        this.lineEndOffset = lineEndOffset;
    }

    @Override
    public String group(int groupNumber) {
        if (this.groupByIndex == null) {
            return null;
        }
        Group group = this.groupByIndex.get(groupNumber);
        return group == null ? null : group.text;
    }

    @Override
    public int start(int groupNumber) {
        if (this.groupByIndex == null) {
            return -1;
        }
        Group group = this.groupByIndex.get(groupNumber);
        return group == null ? -1 : group.start;
    }

    @Override
    public int end(int groupNumber) {
        if (this.groupByIndex == null) {
            return -1;
        }
        Group group = this.groupByIndex.get(groupNumber);
        return group == null ? -1 : group.end;
    }

    public abstract void emit();

    private static class Group {
        private final String text;
        private final int start;
        private final int end;

        public Group(String text, int start, int end) {
            this.text = text;
            this.start = start;
            this.end = end;
        }
    }
}

