/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.builds.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPersistableElement;

public class BuildEditorInput
implements IEditorInput {
    private final IBuildPlan plan;
    private final IBuild build;

    public BuildEditorInput(IBuildPlan plan) {
        Assert.isNotNull((Object)plan);
        this.plan = plan;
        this.build = null;
    }

    public BuildEditorInput(IBuild build) {
        Assert.isNotNull((Object)build);
        Assert.isNotNull((Object)build.getPlan());
        this.plan = build.getPlan();
        this.build = build;
    }

    public IBuild getBuild() {
        return this.build;
    }

    public IBuildPlan getPlan() {
        return this.plan;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IEditorInput.class) {
            return this;
        }
        return null;
    }

    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        if (this.build != null) {
            return NLS.bind((String)"{0}#{1}", (Object)this.plan.getLabel(), (Object)this.build.getLabel());
        }
        return this.plan.getLabel();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return "";
    }
}

