/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.util;

import junit.framework.TestCase;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;
import org.eclipse.mylyn.wikitext.core.parser.util.MarkupToEclipseToc;
import org.eclipse.mylyn.wikitext.tests.TestUtil;
import org.eclipse.mylyn.wikitext.textile.core.TextileLanguage;

public class MarkupToEclipseTocTest
extends TestCase {
    private MarkupToEclipseToc markupToEclipseToc;

    public void setUp() {
        this.markupToEclipseToc = new MarkupToEclipseToc();
        this.markupToEclipseToc.setMarkupLanguage((MarkupLanguage)new TextileLanguage());
    }

    public void testHeader() throws Exception {
        this.markupToEclipseToc.setBookTitle("Test");
        this.markupToEclipseToc.setHtmlFile("Test.html");
        String toc = this.markupToEclipseToc.parse("h1. title1\n\nContent para 1\n\nh1. title2\n\nMore content\n\nh2. Nested title\n\nnested content");
        TestUtil.println("Eclipse TOC: " + toc);
        MarkupToEclipseTocTest.assertEquals((String)"<?xml version='1.0' encoding='utf-8' ?>\n<toc topic=\"Test.html\" label=\"Test\">\n\t<topic href=\"Test.html\" label=\"title1\"></topic>\n\t<topic href=\"Test.html#title2\" label=\"title2\">\n\t\t<topic href=\"Test.html#Nestedtitle\" label=\"Nested title\"></topic>\n\t</topic>\n</toc>", (String)toc);
    }

    public void testCopyrightNotice() {
        this.markupToEclipseToc.setCopyrightNotice("Copyright (c) 2012 David Green");
        String toc = this.markupToEclipseToc.parse("h1. title");
        TestUtil.println("TOC: " + toc);
        MarkupToEclipseTocTest.assertTrue((String)("content: " + toc), (boolean)toc.contains("<!-- Copyright (c) 2012 David Green -->"));
    }
}

