/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.util.anttask;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import org.eclipse.mylyn.wikitext.core.util.anttask.AbstractTestAntTask;
import org.eclipse.mylyn.wikitext.core.util.anttask.MarkupToXslfoTask;

public class MarkupToXslfoTaskTest
extends AbstractTestAntTask {
    private MarkupToXslfoTask task;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.task = new MarkupToXslfoTask();
        this.task.setMarkupLanguage(this.languageName);
    }

    public void testSimpleOutput() throws IOException {
        File markup = this.createSimpleTextileMarkup();
        this.task.setFile(markup);
        this.task.execute();
        this.listFiles();
        File targetFile = new File(markup.getParentFile(), "markup.fo");
        MarkupToXslfoTaskTest.assertTrue((targetFile.exists() && targetFile.isFile() ? 1 : 0) != 0);
        String content = this.getContent(targetFile);
        MarkupToXslfoTaskTest.assertTrue((boolean)content.contains("<root xmlns=\"http://www.w3.org/1999/XSL/Format\""));
        MarkupToXslfoTaskTest.assertTrue((boolean)content.contains("</root>"));
        MarkupToXslfoTaskTest.assertTrue((boolean)content.contains(">markup</block>"));
        MarkupToXslfoTaskTest.assertTrue((boolean)content.contains(" id=\"FirstHeading\">First Heading</block>"));
        MarkupToXslfoTaskTest.assertTrue((boolean)content.contains(" id=\"SecondHeading\">Second Heading</block>"));
    }

    protected File createSimpleTextileMarkup() throws IOException {
        File markupFile = new File(this.tempFolder, "markup.textile");
        PrintWriter writer = new PrintWriter(new FileWriter(markupFile));
        try {
            writer.println("h1. First Heading");
            writer.println();
            writer.println("some content");
            writer.println();
            writer.println("h1. Second Heading");
            writer.println();
            writer.println("some more content");
        }
        finally {
            writer.close();
        }
        return markupFile;
    }

    public void testTaskdef() {
        ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(MarkupToXslfoTask.class.getPackage().getName()) + ".tasks");
        MarkupToXslfoTaskTest.assertEquals((String)MarkupToXslfoTask.class.getName(), (String)bundle.getString("wikitext-to-xslfo"));
    }
}

