/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.ide.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.pde.internal.runtime.logview.LogEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class NewTaskFromErrorAction
implements IViewActionDelegate,
ISelectionChangedListener {
    public static final String ID = "org.eclipse.mylyn.tasklist.ui.repositories.actions.create";
    private TreeViewer treeViewer;

    public void run() {
        TreeItem[] items = this.treeViewer.getTree().getSelection();
        LogEntry selection = null;
        if (items.length > 0) {
            selection = (LogEntry)items[0].getData();
        }
        if (selection == null) {
            return;
        }
        NewTaskWizard wizard = new NewTaskWizard();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null && !shell.isDisposed()) {
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 1) {
                return;
            }
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            AbstractRepositoryTaskEditor editor = null;
            String summary = "";
            String description = "\n\n-- Error Log --\nDate: " + selection.getDate() + "\nMessage: " + selection.getMessage() + "\nSeverity: " + selection.getSeverityText() + "\nPlugin ID: " + selection.getPluginId() + "\nStack Trace:\n" + (selection.getStack() == null ? "no stack trace available" : selection.getStack());
            try {
                TaskEditor taskEditor = (TaskEditor)page.getActiveEditor();
                editor = (AbstractRepositoryTaskEditor)taskEditor.getActivePageInstance();
            }
            catch (ClassCastException classCastException) {
                Clipboard clipboard = new Clipboard(page.getWorkbenchWindow().getShell().getDisplay());
                clipboard.setContents(new Object[]{String.valueOf(summary) + "\n" + description}, new Transfer[]{TextTransfer.getInstance()});
                MessageDialog.openInformation((Shell)page.getWorkbenchWindow().getShell(), (String)"Mylar Information", (String)"This connector does not provide a rich task editor for creating tasks.\n\nThe error contents have been placed in the clipboard so that you can paste them into the entry form.");
                return;
            }
            editor.setSummaryText(summary);
            editor.setDescriptionText(description);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IViewPart view) {
        ISelectionProvider sp = view.getViewSite().getSelectionProvider();
        sp.addSelectionChangedListener((ISelectionChangedListener)this);
        sp.setSelection(sp.getSelection());
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.treeViewer = (TreeViewer)event.getSource();
    }
}

