/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.context.ui.AbstractContextUiBridge;
import org.eclipse.mylyn.context.ui.ContextUiPlugin;
import org.eclipse.mylyn.internal.resources.ui.IContextAwareEditor;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.resources.ResourcesUiBridgePlugin;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.NewTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.internal.EditorManager;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextEditorManager
implements IInteractionContextListener {
    private static final String PREFS_PREFIX = "editors.task.";
    private static final String KEY_CONTEXT_EDITORS = "ContextOpenEditors";
    private boolean previousCloseEditorsSetting = Workbench.getInstance().getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");

    public void contextActivated(IInteractionContext context) {
        if (!Workbench.getInstance().isStarting() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.editors.auto.manage")) {
            Workbench workbench = (Workbench)PlatformUI.getWorkbench();
            this.previousCloseEditorsSetting = workbench.getPreferenceStore().getBoolean("REUSE_OPEN_EDITORS_BOOLEAN");
            workbench.getPreferenceStore().setValue("REUSE_OPEN_EDITORS_BOOLEAN", false);
            boolean wasPaused = ContextCorePlugin.getContextManager().isContextCapturePaused();
            try {
                try {
                    IInteractionElement activeNode;
                    if (!wasPaused) {
                        ContextCorePlugin.getContextManager().setContextCapturePaused(true);
                    }
                    WorkbenchPage page = (WorkbenchPage)workbench.getActiveWorkbenchWindow().getActivePage();
                    String mementoString = null;
                    AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(context.getHandleIdentifier());
                    if (task != null) {
                        try {
                            XMLMemento memento;
                            mementoString = ResourcesUiBridgePlugin.getDefault().getPreferenceStore().getString(PREFS_PREFIX + task.getHandleIdentifier());
                            if (mementoString != null && !mementoString.trim().equals("") && (memento = XMLMemento.createReadRoot((Reader)new StringReader(mementoString))) != null) {
                                this.restoreEditors(page, (IMemento)memento);
                            }
                        }
                        catch (Exception e) {
                            StatusHandler.log((Throwable)e, (String)("Could not restore all editors, memento: " + mementoString + "."));
                        }
                    }
                    if ((activeNode = context.getActiveNode()) != null) {
                        ContextUiPlugin.getDefault().getUiBridge(activeNode.getContentType()).open(activeNode);
                    }
                }
                catch (Exception e) {
                    StatusHandler.fail((Throwable)e, (String)"failed to open editors on activation", (boolean)false);
                    ContextCorePlugin.getContextManager().setContextCapturePaused(false);
                }
            }
            finally {
                ContextCorePlugin.getContextManager().setContextCapturePaused(false);
            }
        }
    }

    public void contextDeactivated(IInteractionContext context) {
        if (!PlatformUI.getWorkbench().isClosing() && ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.editors.auto.manage")) {
            this.closeAllButActiveTaskEditor(context.getHandleIdentifier());
            XMLMemento memento = XMLMemento.createWriteRoot((String)KEY_CONTEXT_EDITORS);
            ((WorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getEditorManager().saveState((IMemento)memento);
            AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(context.getHandleIdentifier());
            if (task != null) {
                StringWriter writer = new StringWriter();
                try {
                    memento.save((Writer)writer);
                    ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setValue(PREFS_PREFIX + task.getHandleIdentifier(), writer.getBuffer().toString());
                }
                catch (IOException e) {
                    StatusHandler.fail((Throwable)e, (String)"Could not store editor state", (boolean)false);
                }
                Workbench.getInstance().getPreferenceStore().setValue("REUSE_OPEN_EDITORS_BOOLEAN", this.previousCloseEditorsSetting);
            }
            this.closeAllEditors();
        }
    }

    public void contextCleared(IInteractionContext context) {
        if (context == null) {
            return;
        }
        this.closeAllButActiveTaskEditor(context.getHandleIdentifier());
        AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(context.getHandleIdentifier());
        XMLMemento memento = XMLMemento.createWriteRoot((String)KEY_CONTEXT_EDITORS);
        if (task != null) {
            StringWriter writer = new StringWriter();
            try {
                memento.save((Writer)writer);
                ResourcesUiBridgePlugin.getDefault().getPreferenceStore().setValue(PREFS_PREFIX + task.getHandleIdentifier(), writer.getBuffer().toString());
            }
            catch (IOException e) {
                StatusHandler.fail((Throwable)e, (String)"Could not store editor state", (boolean)false);
            }
            Workbench.getInstance().getPreferenceStore().setValue("REUSE_OPEN_EDITORS_BOOLEAN", this.previousCloseEditorsSetting);
        }
        this.closeAllEditors();
    }

    private void restoreEditors(WorkbenchPage page, IMemento memento) {
        EditorManager editorManager = page.getEditorManager();
        ArrayList visibleEditors = new ArrayList(5);
        IEditorReference[] activeEditor = new IEditorReference[1];
        MultiStatus result = new MultiStatus("org.eclipse.ui", 0, WorkbenchMessages.EditorManager_problemsRestoringEditors, null);
        try {
            IWorkbenchPart editor;
            IMemento[] editorMementos = memento.getChildren("editor");
            HashSet editorMementoSet = new HashSet();
            editorMementoSet.addAll(Arrays.asList(editorMementos));
            HashSet<String> restoredPartNames = new HashSet<String>();
            List<IEditorReference> alreadyVisibleEditors = Arrays.asList(editorManager.getEditors());
            for (IEditorReference editorReference : alreadyVisibleEditors) {
                restoredPartNames.add(editorReference.getPartName());
            }
            for (IMemento editorMemento : editorMementoSet) {
                String partName = editorMemento.getString("partName");
                if (!restoredPartNames.contains(partName)) {
                    editorManager.restoreEditorState(editorMemento, visibleEditors, activeEditor, result);
                    continue;
                }
                restoredPartNames.add(partName);
            }
            int i = 0;
            while (i < visibleEditors.size()) {
                editorManager.setVisibleEditor((IEditorReference)visibleEditors.get(i), false);
                ++i;
            }
            if (activeEditor[0] != null && (editor = activeEditor[0].getPart(true)) != null) {
                page.activate(editor);
            }
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"Could not restore editors", (boolean)false);
        }
    }

    public void closeAllButActiveTaskEditor(String taskHandle) {
        try {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    IEditorReference[] references = page.getEditorReferences();
                    ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
                    int i = 0;
                    while (i < references.length) {
                        IEditorPart part;
                        if (this.canClose(references[i]) && (part = references[i].getEditor(false)) instanceof TaskEditor) {
                            try {
                                AbstractTask task;
                                IEditorInput input = references[i].getEditorInput();
                                if (input instanceof TaskEditorInput && ((task = ((TaskEditorInput)input).getTask()) == null || !task.getHandleIdentifier().equals(taskHandle))) {
                                    toClose.add(references[i]);
                                }
                            }
                            catch (PartInitException partInitException) {}
                        }
                        ++i;
                    }
                    page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"Could not auto close editor.", (boolean)false);
        }
    }

    public void closeAllEditors() {
        try {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
            int n = iWorkbenchWindowArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWorkbenchWindow window = iWorkbenchWindowArray[n2];
                IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    IEditorReference[] references = page.getEditorReferences();
                    ArrayList<IEditorReference> toClose = new ArrayList<IEditorReference>();
                    int i = 0;
                    while (i < references.length) {
                        if (this.canClose(references[i]) && !this.isUnsubmittedTaskEditor(references[i])) {
                            toClose.add(references[i]);
                        }
                        ++i;
                    }
                    page.closeEditors(toClose.toArray(new IEditorReference[toClose.size()]), true);
                }
                ++n2;
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)"Could not auto close editor.", (boolean)false);
        }
    }

    private boolean canClose(IEditorReference editorReference) {
        IEditorPart editor = editorReference.getEditor(false);
        if (editor instanceof IContextAwareEditor) {
            return ((IContextAwareEditor)editor).canClose();
        }
        return true;
    }

    private boolean isUnsubmittedTaskEditor(IEditorReference editorReference) {
        IEditorPart part = editorReference.getEditor(false);
        if (part instanceof TaskEditor) {
            try {
                IEditorInput input = editorReference.getEditorInput();
                if (input instanceof NewTaskEditorInput) {
                    return true;
                }
            }
            catch (PartInitException partInitException) {}
        }
        return false;
    }

    public void interestChanged(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            this.closeEditor(element, false);
        }
    }

    public void elementDeleted(IInteractionElement element) {
        this.closeEditor(element, true);
    }

    private void closeEditor(IInteractionElement element, boolean force) {
        AbstractContextStructureBridge bridge;
        if (ContextUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.ide.ui.editors.auto.manage") && (force || !element.getInterest().isInteresting()) && (bridge = ContextCorePlugin.getDefault().getStructureBridge(element.getContentType())).isDocument(element.getHandleIdentifier())) {
            AbstractContextUiBridge uiBridge = ContextUiPlugin.getDefault().getUiBridge(element.getContentType());
            uiBridge.close(element);
        }
    }

    public void landmarkAdded(IInteractionElement element) {
    }

    public void landmarkRemoved(IInteractionElement element) {
    }

    public void relationsChanged(IInteractionElement element) {
    }
}

