/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import org.eclipse.core.internal.resources.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.AbstractUserInteractionMonitor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.EditorPart;

public class ResourceInteractionMonitor
extends AbstractUserInteractionMonitor {
    protected void handleWorkbenchPartSelection(IWorkbenchPart part, ISelection selection, boolean contributeToContext) {
        if (selection instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)selection;
            Object selectedObject = structuredSelection.getFirstElement();
            if (selectedObject instanceof File) {
                File file = (File)selectedObject;
                super.handleElementSelection(part, (Object)file, contributeToContext);
            }
        } else if (selection instanceof TextSelection && part instanceof EditorPart) {
            try {
                Object object = ((EditorPart)part).getEditorInput().getAdapter(IResource.class);
                if (object instanceof IFile) {
                    IFile file = (IFile)object;
                    if (!ContextCorePlugin.getDefault().getKnownContentTypes().contains(file.getFileExtension())) {
                        super.handleElementEdit(part, object, contributeToContext);
                    }
                }
            }
            catch (Throwable t) {
                StatusHandler.log((Throwable)t, (String)"failed to resolve resource edit");
            }
        }
    }
}

