/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui.preferences;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mylyn.internal.resources.ui.ResourcesUiPreferenceInitializer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FocusedResourcesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table ignoreTable;
    private Button addButton;
    private Button removeButton;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.createExcludesTable(parent);
        return parent;
    }

    private void createExcludesTable(Composite parent) {
        Group group = new Group(parent, 16);
        group.setText("Resource Monitoring Exclusions");
        GridLayout layout = new GridLayout(1, false);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)layout);
        Composite composite = new Composite((Composite)group, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label l1 = new Label(composite, 0);
        l1.setText("Matching file or directory names will not be added automatically to the context");
        GridData data = new GridData(2);
        data.horizontalSpan = 2;
        l1.setLayoutData((Object)data);
        this.ignoreTable = new Table(composite, 2048);
        data = new GridData(1808);
        data.heightHint = 60;
        this.ignoreTable.setLayoutData((Object)data);
        this.ignoreTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FocusedResourcesPreferencePage.this.handleSelection();
            }
        });
        Composite buttons = new Composite(composite, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText("Add...");
        this.addButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FocusedResourcesPreferencePage.this.addIgnore();
            }
        });
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                FocusedResourcesPreferencePage.this.removeIgnore();
            }
        });
        this.fillTable(ResourcesUiPreferenceInitializer.getExcludedResourcePatterns());
        Dialog.applyDialogFont((Control)group);
        this.setButtonLayoutData(this.addButton);
        this.setButtonLayoutData(this.removeButton);
    }

    public boolean performOk() {
        HashSet<String> patterns = new HashSet<String>();
        TableItem[] items = this.ignoreTable.getItems();
        int i = 0;
        while (i < items.length) {
            patterns.add(items[i].getText());
            ++i;
        }
        ResourcesUiPreferenceInitializer.setExcludedResourcePatterns(patterns);
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.ignoreTable.removeAll();
        ResourcesUiPreferenceInitializer.restoreDefaultExcludedResourcePatterns();
        this.fillTable(ResourcesUiPreferenceInitializer.getExcludedResourcePatterns());
    }

    private void fillTable(Set<String> ignored) {
        for (String pattern : ignored) {
            TableItem item = new TableItem(this.ignoreTable, 0);
            item.setText(pattern);
        }
    }

    private void addIgnore() {
        InputDialog dialog = new InputDialog(this.getShell(), "Add Ignored Resource", "Enter pattern (* = any string)", null, null);
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        String pattern = dialog.getValue();
        if (pattern.equals("")) {
            return;
        }
        TableItem item = new TableItem(this.ignoreTable, 0);
        item.setText(pattern);
        item.setChecked(true);
    }

    private void removeIgnore() {
        int[] selection = this.ignoreTable.getSelectionIndices();
        this.ignoreTable.remove(selection);
    }

    private void handleSelection() {
        if (this.ignoreTable.getSelectionCount() > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }
}

