/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.resources.ui.ContextEditorManager;
import org.eclipse.mylyn.internal.resources.ui.EditorInteractionMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourceChangeMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourceInteractionMonitor;
import org.eclipse.mylyn.internal.resources.ui.ResourceInterestUpdater;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourcesUiBridgePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.resources.ui";
    private static ResourcesUiBridgePlugin INSTANCE;
    private ResourceChangeMonitor resourceChangeMonitor = new ResourceChangeMonitor();
    private ContextEditorManager editorManager = new ContextEditorManager();
    private ResourceInteractionMonitor resourceInteractionMonitor;
    private EditorInteractionMonitor interestEditorTracker = new EditorInteractionMonitor();
    private ResourceInterestUpdater interestUpdater = new ResourceInterestUpdater();
    private ResourceBundle resourceBundle;
    private static final String PREF_STORE_DELIM = ", ";
    public static final String PREF_RESOURCES_IGNORED = "org.eclipse.mylyn.ide.resources.ignored.pattern";
    public static final String PREF_VAL_DEFAULT_RESOURCES_IGNORED = ".*, ";

    public ResourcesUiBridgePlugin() {
        INSTANCE = this;
        this.resourceInteractionMonitor = new ResourceInteractionMonitor();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initPreferenceDefaults();
        ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)this.editorManager);
        MonitorUiPlugin.getDefault().getSelectionMonitors().add(this.resourceInteractionMonitor);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.resourceChangeMonitor, 1);
        this.interestEditorTracker.install(PlatformUI.getWorkbench());
    }

    public void stop(BundleContext context) throws Exception {
        try {
            super.stop(context);
            INSTANCE = null;
            this.resourceBundle = null;
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.resourceChangeMonitor);
            ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this.editorManager);
            MonitorUiPlugin.getDefault().getSelectionMonitors().remove((Object)this.resourceInteractionMonitor);
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"Mylar XML stop failed", (boolean)false);
        }
    }

    private void initPreferenceDefaults() {
        this.getPreferenceStore().setDefault(PREF_RESOURCES_IGNORED, PREF_VAL_DEFAULT_RESOURCES_IGNORED);
    }

    public List<IResource> getInterestingResources(IInteractionContext context) {
        ArrayList<IResource> interestingResources = new ArrayList<IResource>();
        Collection resourceElements = ContextCorePlugin.getContextManager().getInterestingDocuments(context);
        for (IInteractionElement element : resourceElements) {
            IResource resource = this.getResourceForElement(element, false);
            if (resource == null) continue;
            interestingResources.add(resource);
        }
        return interestingResources;
    }

    public void setExcludedResourcePatterns(Set<String> patterns) {
        StringBuilder store = new StringBuilder();
        for (String string : patterns) {
            store.append(string);
            store.append(PREF_STORE_DELIM);
        }
        this.getPreferenceStore().setValue(PREF_RESOURCES_IGNORED, store.toString());
    }

    public Set<String> getExcludedResourcePatterns() {
        HashSet<String> ignored = new HashSet<String>();
        String read = this.getPreferenceStore().getString(PREF_RESOURCES_IGNORED);
        if (read != null) {
            StringTokenizer st = new StringTokenizer(read, PREF_STORE_DELIM);
            while (st.hasMoreTokens()) {
                ignored.add(st.nextToken());
            }
        }
        return ignored;
    }

    public static ResourceInterestUpdater getInterestUpdater() {
        return ResourcesUiBridgePlugin.INSTANCE.interestUpdater;
    }

    public IResource getResourceForElement(IInteractionElement element, boolean findContainingResource) {
        Object adapted;
        if (element == null) {
            return null;
        }
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(element.getContentType());
        Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
        if (object instanceof IResource) {
            return (IResource)object;
        }
        if (object instanceof IAdaptable && (adapted = ((IAdaptable)object).getAdapter(IResource.class)) instanceof IResource) {
            return (IResource)adapted;
        }
        if (findContainingResource) {
            String parentHandle = bridge.getParentHandle(element.getHandleIdentifier());
            if (element.getHandleIdentifier().equals(parentHandle)) {
                return null;
            }
            return this.getResourceForElement(ContextCorePlugin.getContextManager().getElement(parentHandle), true);
        }
        return null;
    }

    public void setResourceMonitoringEnabled(boolean enabled) {
        this.resourceChangeMonitor.setEnabled(enabled);
    }

    public static ContextEditorManager getEditorManager() {
        return ResourcesUiBridgePlugin.INSTANCE.editorManager;
    }

    public static ResourcesUiBridgePlugin getDefault() {
        return INSTANCE;
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.mylyn.xml.XmlPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }
}

