/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.tests.support;

import java.util.Arrays;
import java.util.List;
import org.eclipse.mylyn.builds.core.BuildState;
import org.eclipse.mylyn.builds.core.BuildStatus;
import org.eclipse.mylyn.builds.core.IBuild;
import org.eclipse.mylyn.builds.core.IBuildFactory;
import org.eclipse.mylyn.builds.core.IBuildModel;
import org.eclipse.mylyn.builds.core.IBuildPlan;
import org.eclipse.mylyn.builds.core.IBuildServer;
import org.eclipse.mylyn.builds.internal.core.Build;
import org.eclipse.mylyn.builds.internal.core.BuildModel;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.internal.core.IBuildLoader;
import org.eclipse.mylyn.builds.tests.support.MockBuildLoader;
import org.eclipse.mylyn.builds.tests.support.MockOperationService;
import org.eclipse.mylyn.builds.ui.BuildsUi;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.ICredentialsStore;
import org.eclipse.mylyn.internal.commons.repositories.core.InMemoryCredentialsStore;

public class BuildHarness {
    private final BuildModel model;
    private final MockOperationService operationService;
    private final MockBuildLoader loader;
    private BuildServer server;

    public BuildHarness(IBuildModel model) {
        this.model = (BuildModel)model;
        this.loader = new MockBuildLoader();
        this.operationService = new MockOperationService(this.loader.getRealm());
    }

    public BuildHarness() {
        this(BuildsUi.getModel());
    }

    public void dispose() {
        this.getModel().getServers().clear();
    }

    public BuildModel getModel() {
        return this.model;
    }

    public MockOperationService getOperationService() {
        return this.operationService;
    }

    public BuildServer createServer() {
        this.server = (BuildServer)IBuildFactory.INSTANCE.createBuildServer();
        this.server.setConnectorKind("org.eclipse.mylyn.builds.tests.mock");
        this.server.setLoader((IBuildLoader)this.loader);
        RepositoryLocation location = new RepositoryLocation();
        this.server.setLocation(location);
        location.setCredentialsStore((ICredentialsStore)new InMemoryCredentialsStore());
        location.setUrl("http://ci.mylyn.org/");
        this.getModel().getServers().add(this.server);
        return this.server;
    }

    public IBuild createBuild() {
        Build build = (Build)IBuildFactory.INSTANCE.createBuild();
        return build;
    }

    public List<IBuildPlan> createPlans() {
        IBuildPlan failingPlan = IBuildFactory.INSTANCE.createBuildPlan();
        failingPlan.setId("1");
        failingPlan.setName("Failing Build Plan");
        failingPlan.setState(BuildState.RUNNING);
        failingPlan.setStatus(BuildStatus.FAILED);
        failingPlan.setHealth(15);
        IBuildPlan childPlan1 = IBuildFactory.INSTANCE.createBuildPlan();
        childPlan1.setId("1.1");
        childPlan1.setName("Stopped Child Build Plan");
        childPlan1.setState(BuildState.STOPPED);
        childPlan1.setStatus(BuildStatus.FAILED);
        IBuildPlan childPlan2 = IBuildFactory.INSTANCE.createBuildPlan();
        childPlan2.setId("1.2");
        childPlan2.setName("Running Child Build Plan");
        childPlan2.setState(BuildState.STOPPED);
        childPlan2.setStatus(BuildStatus.FAILED);
        childPlan2.setHealth(55);
        IBuildPlan succeedingPlan = IBuildFactory.INSTANCE.createBuildPlan();
        succeedingPlan.setId("2");
        succeedingPlan.setName("Succeeding Build Plan");
        succeedingPlan.setState(BuildState.STOPPED);
        succeedingPlan.setStatus(BuildStatus.SUCCESS);
        succeedingPlan.setInfo("12 tests passing");
        succeedingPlan.setHealth(89);
        return Arrays.asList(failingPlan, childPlan1, childPlan2, succeedingPlan);
    }

    public IBuildPlan createBuildPlan() {
        IBuildPlan plan = IBuildFactory.INSTANCE.createBuildPlan();
        plan.setId("plan");
        plan.setServer(this.getServer());
        this.getModel().getPlans().add(plan);
        return plan;
    }

    public IBuildServer getServer() {
        return this.server;
    }
}

