/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.builds.tests.util;

import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.builds.internal.core.BuildServer;
import org.eclipse.mylyn.builds.tests.support.BuildHarness;
import org.eclipse.mylyn.commons.workbench.EditorHandle;
import org.eclipse.mylyn.commons.workbench.browser.BrowserUtil;
import org.eclipse.mylyn.internal.builds.ui.editor.BuildEditor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class BuildsUrlHandlerTest
extends TestCase {
    private IWorkbenchPage activePage;
    private BuildHarness harness;
    private BuildServer server;

    protected void setUp() throws Exception {
        this.activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        BuildsUrlHandlerTest.assertNotNull((Object)this.activePage);
        this.harness = new BuildHarness();
        this.server = this.harness.createServer();
    }

    protected void tearDown() throws Exception {
        this.harness.dispose();
    }

    public void testOpenUrl() throws Exception {
        EditorHandle handler = BrowserUtil.openUrl((IWorkbenchPage)this.activePage, (String)(String.valueOf(this.server.getUrl()) + "/123"), (int)0);
        long startTime = System.currentTimeMillis();
        Display display = PlatformUI.getWorkbench().getDisplay();
        while (!display.isDisposed()) {
            if (display.readAndDispatch()) continue;
            if (handler.await(500L, TimeUnit.MILLISECONDS)) break;
            BuildsUrlHandlerTest.assertTrue((String)"Expected editor did not open within 10 seconds", (System.currentTimeMillis() - startTime < 10000L ? 1 : 0) != 0);
        }
        BuildsUrlHandlerTest.assertEquals((Object)Status.OK_STATUS, (Object)handler.getStatus());
        BuildsUrlHandlerTest.assertEquals(BuildEditor.class, this.activePage.getActiveEditor().getClass());
    }
}

