/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.scoping.members;

import java.util.List;
import org.eclipse.n4js.scoping.members.ComposedMemberDescriptionWithError;
import org.eclipse.n4js.ts.typeRefs.ComposedTypeRef;
import org.eclipse.n4js.validation.IssueCodes;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IScope;

public class IntersectionMemberDescriptionWithError
extends ComposedMemberDescriptionWithError {
    public IntersectionMemberDescriptionWithError(IEObjectDescription delegate, ComposedTypeRef composedTypeRef, IScope[] subScopes, boolean writeAccess) {
        super(delegate, composedTypeRef, subScopes, writeAccess);
    }

    @Override
    protected boolean initMessageAndCode(List<String> missingFrom, ComposedMemberDescriptionWithError.MapOfIndexes<String> indexesPerMemberType, QualifiedName name, boolean readOnlyField, IEObjectDescription[] descriptions, ComposedMemberDescriptionWithError.MapOfIndexes<String> indexesPerCode) {
        return this.initMemberTypeConflict(indexesPerMemberType) || this.initSubMessages(descriptions, indexesPerCode) || this.initDefault();
    }

    private boolean initMemberTypeConflict(ComposedMemberDescriptionWithError.MapOfIndexes<String> indexesPerMemberType) {
        if (indexesPerMemberType.size() > 1) {
            StringBuilder strb = new StringBuilder();
            for (String memberTypeName : indexesPerMemberType.keySet()) {
                String foundScopes = indexesPerMemberType.getScopeNamesForKey(memberTypeName);
                if (strb.length() != 0) {
                    strb.append("; ");
                }
                strb.append(String.valueOf(memberTypeName) + " in " + foundScopes);
            }
            String memberName = this.getName().getLastSegment();
            this.message = IssueCodes.getMessageForINTER_MEMBER_TYPE_CONFLICT(memberName, strb);
            this.code = "INTER_MEMBER_TYPE_CONFLICT";
            return true;
        }
        return false;
    }

    private boolean initDefault() {
        String memberName = this.getName().getLastSegment();
        this.message = IssueCodes.getMessageForINTER_UNCOMMON(memberName);
        this.code = "INTER_UNCOMMON";
        return true;
    }
}

