/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;

public class WorkbenchRunnableAdapter
implements IRunnableWithProgress,
IThreadListener {
    private IWorkspaceRunnable workspaceRunnable;
    private ISchedulingRule rule;
    private boolean fTransfer;

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule) {
        this(runnable, rule, true);
    }

    public WorkbenchRunnableAdapter(IWorkspaceRunnable runnable, ISchedulingRule rule, boolean transfer) {
        Assert.isNotNull((Object)runnable);
        Assert.isNotNull((Object)rule);
        this.workspaceRunnable = runnable;
        this.rule = rule;
        this.fTransfer = transfer;
    }

    public ISchedulingRule getSchedulingRule() {
        return this.rule;
    }

    public void threadChange(Thread thread) {
        if (this.fTransfer) {
            Job.getJobManager().transferRule(this.rule, thread);
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            ResourcesPlugin.getWorkspace().run(this.workspaceRunnable, this.rule, 1, monitor);
        }
        catch (OperationCanceledException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }
}

