/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.project.facet.core.internal;

import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IFacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.common.project.facet.core.internal.FacetCorePlugin;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectTemplate;
import org.eclipse.wst.common.project.facet.core.internal.ProblemLog;
import org.eclipse.wst.common.project.facet.core.util.internal.IndexedSet;
import org.eclipse.wst.common.project.facet.core.util.internal.PluginUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FacetedProjectTemplatesExtensionPoint {
    public static final String EXTENSION_POINT_ID = "facets";
    private static final String ATTR_FACET = "facet";
    private static final String ATTR_ID = "id";
    private static final String EL_FIXED = "fixed";
    private static final String EL_LABEL = "label";
    private static final String EL_PRESET = "preset";
    private static final String EL_TEMPLATE = "template";
    private static IndexedSet<String, IFacetedProjectTemplate> templates = null;

    public static Set<IFacetedProjectTemplate> getTemplates() {
        FacetedProjectTemplatesExtensionPoint.readExtensions();
        return templates.getItemSet();
    }

    public static IFacetedProjectTemplate getTemplate(String id) {
        FacetedProjectTemplatesExtensionPoint.readExtensions();
        return templates.getItemByKey(id);
    }

    private static synchronized void readExtensions() {
        if (templates != null) {
            return;
        }
        templates = new IndexedSet();
        for (IConfigurationElement element : PluginUtil.getTopLevelElements(PluginUtil.findExtensions("org.eclipse.wst.common.project.facet.core", EXTENSION_POINT_ID))) {
            if (!element.getName().equals(EL_TEMPLATE)) continue;
            try {
                FacetedProjectTemplatesExtensionPoint.readTemplate(element);
            }
            catch (PluginUtil.InvalidExtensionException invalidExtensionException) {}
        }
    }

    private static void readTemplate(IConfigurationElement config) throws PluginUtil.InvalidExtensionException {
        String pluginId = config.getContributor().getName();
        FacetedProjectTemplate template = new FacetedProjectTemplate();
        template.setId(PluginUtil.findRequiredAttribute(config, ATTR_ID));
        IConfigurationElement elLabel = PluginUtil.findOptionalElement(config, EL_LABEL);
        template.setLabel(PluginUtil.getElementValue(elLabel, template.getId()));
        IConfigurationElement[] children = config.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String childName = child.getName();
            if (childName.equals(EL_FIXED)) {
                String fid = PluginUtil.findRequiredAttribute(child, ATTR_FACET);
                if (!ProjectFacetsManager.isProjectFacetDefined(fid)) {
                    ProblemLog.reportMissingFacet(fid, pluginId);
                    return;
                }
                template.addFixedProjectFacet(ProjectFacetsManager.getProjectFacet(fid));
            } else if (childName.equals(EL_PRESET)) {
                String pid = PluginUtil.findRequiredAttribute(child, ATTR_ID);
                if (!ProjectFacetsManager.isPresetDefined(pid)) {
                    String msg = Resources.bind((String)Resources.presetNotDefined, (Object)pid, (Object)pluginId);
                    FacetCorePlugin.log(msg);
                    return;
                }
                template.setInitialPreset(ProjectFacetsManager.getPreset(pid));
            }
            ++i;
        }
        templates.addItemWithKey(template.getId(), template);
    }

    private static final class Resources
    extends NLS {
        public static String presetNotDefined;

        static {
            Resources.initializeMessages((String)FacetedProjectTemplatesExtensionPoint.class.getName(), Resources.class);
        }

        private Resources() {
        }
    }
}

