/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.jsdoc2spec.adoc;

import com.google.common.base.StandardSystemProperty;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;

public class FileSystem {
    public static final String NL = StandardSystemProperty.LINE_SEPARATOR.value();
    public static final String DIR_MODULES = "modules";
    public static final String DIR_PACKAGES = "packages";
    public static final String DIR_ADOC_GEN = "api-gen";
    public static final String SEP = File.separator;
    public static final String INDEX_FILE_NAME = "index.idx";

    public static void ensureFileStructure(File root) throws IOException {
        if (!root.exists()) {
            root.mkdir();
        }
        if (!DIR_ADOC_GEN.equals(root.getName())) {
            root.toPath().resolve(DIR_ADOC_GEN).toFile().mkdir();
        }
    }

    public static int getAdocFileCount(String dirPath) {
        return FileSystem.getAdocFileNames(dirPath).size();
    }

    public static ArrayList<String> getAdocFileNames(String dirPath) {
        ArrayList<String> fileNames = new ArrayList<String>();
        FileSystem.getAdocFileNames(Paths.get(dirPath, new String[0]), dirPath, fileNames);
        return fileNames;
    }

    private static void getAdocFileNames(Path rootDirPath, String dirPath, ArrayList<String> fileNames) {
        File f = new File(dirPath);
        File[] files = f.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.getName().endsWith(".adoc")) {
                    Path filePath = file.toPath();
                    String relFileName = rootDirPath.relativize(filePath).toString();
                    fileNames.add(relFileName);
                }
                if (file.isDirectory()) {
                    FileSystem.getAdocFileNames(rootDirPath, file.getAbsolutePath(), fileNames);
                }
                ++i;
            }
        }
    }

    static class CopyFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Path targetPath;
        private Path sourcePath = null;

        public CopyFileVisitor(Path targetPath) {
            this.targetPath = targetPath;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            if (this.sourcePath == null) {
                this.sourcePath = dir;
            } else {
                Files.createDirectories(this.targetPath.resolve(this.sourcePath.relativize(dir)), new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.getFileName().endsWith("dummy")) {
                return FileVisitResult.CONTINUE;
            }
            Path tgtPath = this.targetPath.resolve(this.sourcePath.relativize(file));
            if (tgtPath.toFile().exists()) {
                return FileVisitResult.CONTINUE;
            }
            Files.copy(file, tgtPath, new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }
    }
}

