/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.cli.lsp;

import com.google.common.util.concurrent.Futures;
import com.google.inject.Injector;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.jsonrpc.Launcher;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.n4js.cli.N4jscConsole;
import org.eclipse.n4js.cli.N4jscFactory;
import org.eclipse.n4js.cli.N4jscOptions;
import org.eclipse.n4js.ide.server.N4JSLanguageServerImpl;

public class LspServer {
    private final N4jscOptions options;

    public static void start(N4jscOptions options) throws Exception {
        LspServer server = new LspServer(options);
        server.start();
    }

    private LspServer(N4jscOptions options) {
        this.options = options;
    }

    public void start() throws Exception {
        N4jscConsole.println("Start LSP server");
        ExecutorService threadPool = Executors.newCachedThreadPool();
        AsynchronousServerSocketChannel serverSocket = AsynchronousServerSocketChannel.open().bind(new InetSocketAddress("localhost", this.options.getPort()));
        try {
            while (true) {
                this.run(serverSocket, threadPool);
            }
        }
        catch (Throwable throwable) {
            N4jscConsole.println("LSP server terminated.");
            throw throwable;
        }
    }

    private void run(AsynchronousServerSocketChannel serverSocket, ExecutorService threadPool) throws InterruptedException, ExecutionException, IOException {
        Injector injector = N4jscFactory.createInjector();
        N4JSLanguageServerImpl languageServer = N4jscFactory.getLanguageServer(injector);
        N4jscConsole.println("Listening for LSP clients...");
        AsynchronousSocketChannel socketChannel = serverSocket.accept().get();
        N4jscConsole.println("Connected to LSP client");
        InputStream in = Channels.newInputStream(socketChannel);
        OutputStream out = Channels.newOutputStream(socketChannel);
        Launcher launcher = Launcher.createIoLauncher((Object)languageServer, LanguageClient.class, (InputStream)in, (OutputStream)out, (ExecutorService)threadPool, a -> a);
        languageServer.connect((LanguageClient)launcher.getRemoteProxy());
        Futures.getUnchecked((Future)launcher.startListening());
        N4jscConsole.println("Shutdown connection to LSP client");
        languageServer.getRequestManager().shutdown();
        in.close();
        out.close();
        socketChannel.close();
    }
}

