/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.util.Util;

public class ClasspathJrtWithReleaseOption
extends ClasspathJrt {
    static String MODULE_INFO = "module-info.sig";
    final String release;
    String releaseInHex;
    private String[] subReleases;
    private FileSystem fs;
    protected Path releasePath;
    protected Path modulePath;
    private String modPathString;
    private boolean isJRE12Plus;

    public ClasspathJrtWithReleaseOption(String zipFilename, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, String release) throws CoreException {
        if (release == null || release.equals("")) {
            throw new IllegalArgumentException("--release argument can not be null");
        }
        this.zipFilename = zipFilename;
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
        this.release = this.getReleaseOptionFromCompliance(release);
        this.initialize();
        ClasspathJrtWithReleaseOption.loadModules(this);
    }

    private String getReleaseOptionFromCompliance(String comp) {
        if (JavaCore.compareJavaVersions(comp, "1.5") <= 0) {
            return "6";
        }
        int index = comp.indexOf("1.");
        if (index != -1) {
            return comp.substring(index + 2, comp.length());
        }
        return comp;
    }

    private boolean isJRE12Plus(Path path) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                for (Path subdir : stream) {
                    String rel = JRTUtil.sanitizedFileName(subdir);
                    if (!Files.exists(this.fs.getPath(rel, "system-modules"), new LinkOption[0])) continue;
                    int parseInt = Integer.parseInt(rel, 16);
                    boolean bl = parseInt > 11;
                    return bl;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            this.fs = null;
        }
        return false;
    }

    protected void initialize() throws CoreException {
        this.releaseInHex = Integer.toHexString(Integer.parseInt(this.release)).toUpperCase();
        Path lib = Paths.get(this.zipFilename, new String[0]).getParent();
        Path filePath = Paths.get(lib.toString(), "ct.sym");
        URI t = filePath.toUri();
        if (!Files.exists(filePath, new LinkOption[0])) {
            return;
        }
        URI uri = URI.create("jar:file:" + t.getRawPath());
        try {
            this.fs = FileSystems.getFileSystem(uri);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {}
        if (this.fs == null) {
            HashMap env = new HashMap();
            try {
                this.fs = FileSystems.newFileSystem(uri, env);
            }
            catch (IOException iOException) {
                return;
            }
        }
        this.releasePath = this.fs.getPath("/", new String[0]);
        this.isJRE12Plus = this.isJRE12Plus(this.releasePath);
        Path modPath = this.fs.getPath(String.valueOf(this.releaseInHex) + (this.isJRE12Plus ? "" : "-modules"), new String[0]);
        if (Files.exists(modPath, new LinkOption[0])) {
            this.modulePath = modPath;
            this.modPathString = String.valueOf(this.zipFilename) + "|" + modPath.toString();
        }
        if (!Files.exists(this.releasePath.resolve(this.releaseInHex), new LinkOption[0])) {
            IllegalArgumentException e = new IllegalArgumentException("release " + this.release + " is not found in the system");
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.core", e.getMessage(), (Throwable)e));
        }
        if (Files.exists(this.fs.getPath(this.releaseInHex, "system-modules"), new LinkOption[0])) {
            this.fs = null;
            return;
        }
        if (this.release != null) {
            ArrayList<String> sub = new ArrayList<String>();
            try {
                Throwable throwable = null;
                Object var8_10 = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.releasePath);){
                    for (Path subdir : stream) {
                        String rel = JRTUtil.sanitizedFileName(subdir);
                        if (!rel.contains(this.releaseInHex)) continue;
                        sub.add(rel);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                this.fs = null;
            }
            this.subReleases = sub.toArray(new String[sub.size()]);
        }
    }

    static HashMap<String, SimpleSet> findPackagesInModules(ClasspathJrtWithReleaseOption jrt) {
        if (jrt.fs == null || !jrt.isJRE12Plus) {
            return ClasspathJrt.findPackagesInModules(jrt);
        }
        String zipFileName = jrt.zipFilename;
        HashMap cache = (HashMap)PackageCache.get(jrt.modPathString);
        if (cache != null) {
            return cache;
        }
        final HashMap<String, SimpleSet> packagesInModule = new HashMap<String, SimpleSet>();
        PackageCache.put(jrt.modPathString, packagesInModule);
        try {
            File imageFile = new File(zipFileName);
            JRTUtil.walkModuleImage(imageFile, jrt.release, new JRTUtil.JrtFileVisitor<Path>(){
                SimpleSet packageSet = null;

                @Override
                public FileVisitResult visitPackage(Path dir, Path mod, BasicFileAttributes attrs) throws IOException {
                    ClasspathJar.addToPackageSet(this.packageSet, dir.toString(), true);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, Path mod, BasicFileAttributes attrs) throws IOException {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitModule(Path path, String name) throws IOException {
                    this.packageSet = new SimpleSet(41);
                    this.packageSet.add("");
                    if (name.endsWith("/")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    packagesInModule.put(name, this.packageSet);
                    return FileVisitResult.CONTINUE;
                }
            }, JRTUtil.NOTIFY_PACKAGES | JRTUtil.NOTIFY_MODULES);
        }
        catch (IOException iOException) {}
        return packagesInModule;
    }

    public static void loadModules(final ClasspathJrtWithReleaseOption jrt) {
        if (jrt.fs == null || !jrt.isJRE12Plus) {
            ClasspathJrt.loadModules(jrt);
            return;
        }
        if (jrt.modPathString == null) {
            return;
        }
        Set cache = (Set)ModulesCache.get(jrt.modPathString);
        if (cache == null) {
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(jrt.releasePath);){
                    for (Path subdir : stream) {
                        if (!subdir.getFileName().toString().contains(jrt.releaseInHex)) continue;
                        Files.walkFileTree(subdir, Collections.EMPTY_SET, 2, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                            @Override
                            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult visitFile(Path f, BasicFileAttributes attrs) throws IOException {
                                if (attrs.isDirectory() || f.getNameCount() < 3) {
                                    return FileVisitResult.CONTINUE;
                                }
                                if (f.getFileName().toString().equals(MODULE_INFO)) {
                                    byte[] content = JRTUtil.safeReadBytes(f);
                                    if (content == null) {
                                        return FileVisitResult.CONTINUE;
                                    }
                                    jrt.acceptModule(content);
                                }
                                return FileVisitResult.SKIP_SIBLINGS;
                            }

                            @Override
                            public FileVisitResult visitFileFailed(Path f, IOException exc) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }

                            @Override
                            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                                return FileVisitResult.CONTINUE;
                            }
                        });
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (this.fs == null) {
            return super.findClass(binaryFileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
        }
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        try {
            block22: {
                block23: {
                    reader = null;
                    content = null;
                    fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
                    if (this.subReleases == null || this.subReleases.length <= 0) break block23;
                    qualifiedBinaryFileName = qualifiedBinaryFileName.replace(".class", ".sig");
                    var13_10 = this.subReleases;
                    var12_11 = this.subReleases.length;
                    var11_12 = 0;
                    while (var11_12 < var12_11) {
                        block21: {
                            rel = var13_10[var11_12];
                            p = null;
                            if (!this.isJRE12Plus) ** GOTO lbl44
                            if (moduleName != null) {
                                p = this.fs.getPath(rel, new String[]{moduleName, qualifiedBinaryFileName});
                            } else {
                                var15_15 = null;
                                var16_17 = null;
                                try {
                                    stream = Files.newDirectoryStream(this.fs.getPath(rel, new String[0]));
                                    try {
                                        for (Path subdir : stream) {
                                            p = subdir.resolve(qualifiedBinaryFileName);
                                            if (!Files.exists(p, new LinkOption[0])) continue;
                                            if (subdir.getNameCount() == 2) {
                                                moduleName = subdir.getName(1).toString();
                                            }
                                            break block21;
                                        }
                                        break block21;
                                    }
                                    finally {
                                        if (stream != null) {
                                            stream.close();
                                        }
                                    }
                                }
                                catch (Throwable var16_18) {
                                    if (var15_15 == null) {
                                        var15_15 = var16_18;
                                    } else if (var15_15 != var16_18) {
                                        var15_15.addSuppressed(var16_18);
                                    }
                                    throw var15_15;
                                }
lbl44:
                                // 1 sources

                                p = this.fs.getPath(rel, new String[]{qualifiedBinaryFileName});
                            }
                        }
                        if (Files.exists(p, new LinkOption[0]) && (content = JRTUtil.safeReadBytes(p)) != null) {
                            reader = new ClassFileReader(content, qualifiedBinaryFileName.toCharArray());
                            if (moduleName != null) {
                                reader.moduleName = moduleName.toCharArray();
                            }
                            break block22;
                        }
                        ++var11_12;
                    }
                    break block22;
                }
                reader = ClassFileReader.readFromModule(new File(this.zipFilename), moduleName, qualifiedBinaryFileName, moduleNameFilter);
            }
            return this.createAnswer(fileNameWithoutExtension, reader);
        }
        catch (IOException | ClassFormatException v0) {
            return null;
        }
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> limitModules) {
        HashMap<String, SimpleSet> cache = ClasspathJrtWithReleaseOption.findPackagesInModules(this);
        if (cache != null) {
            return this.selectModules(cache.keySet(), limitModules);
        }
        return Collections.emptyList();
    }

    @Override
    public void cleanup() {
        try {
            super.reset();
        }
        finally {
            this.fs = null;
        }
    }

    @Override
    public boolean hasModule() {
        return this.fs == null ? super.hasModule() : this.modPathString != null;
    }

    @Override
    protected String getKey() {
        return this.fs == null ? super.getKey() : this.modPathString;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJrtWithReleaseOption)) {
            return false;
        }
        ClasspathJrtWithReleaseOption jar = (ClasspathJrtWithReleaseOption)o;
        if (!Util.equalOrNull(this.release, jar.release)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        int hash = this.zipFilename == null ? super.hashCode() : this.zipFilename.hashCode();
        return Util.combineHashCodes(hash, this.release.hashCode());
    }

    @Override
    public String toString() {
        String start = "Classpath jrt file " + this.zipFilename + " with --release option " + this.release;
        return start;
    }
}

