/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.internal.lsp;

import com.google.common.collect.FluentIterable;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.projectModel.IN4JSSourceContainer;
import org.eclipse.n4js.projectModel.locations.SafeURI;
import org.eclipse.n4js.projectModel.lsp.IN4JSProjectConfig;
import org.eclipse.n4js.projectModel.lsp.IN4JSSourceFolder;

public class N4JSSourceFolder
implements IN4JSSourceFolder {
    private final IN4JSSourceContainer delegate;
    private final IN4JSProjectConfig project;

    public N4JSSourceFolder(IN4JSProjectConfig project, IN4JSSourceContainer delegate) {
        this.project = project;
        this.delegate = delegate;
    }

    @Override
    public IN4JSProjectConfig getProject() {
        return this.project;
    }

    public String getName() {
        return this.delegate.getRelativeLocation();
    }

    public URI getPath() {
        return ((SafeURI)this.delegate.getLocation().withTrailingPathDelimiter()).toURI();
    }

    @Override
    public boolean contains(URI uri) {
        URI path = this.getPath();
        URI uRI = uri = uri.hasTrailingPathSeparator() ? uri : uri.appendSegment("");
        if (!uri.toFileString().startsWith(path.toFileString())) {
            return false;
        }
        URI relUri = uri.deresolve(path);
        if (relUri.segmentCount() > 0) {
            boolean uriInsideNodeModules = relUri.segment(0).equals("node_modules");
            return !uriInsideNodeModules;
        }
        return true;
    }

    @Override
    public List<URI> getAllResources() {
        return FluentIterable.from((Iterable)this.delegate).toList();
    }
}

