/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ide.server;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.BiConsumer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.emf.common.util.URI;
import org.eclipse.n4js.ide.server.HashedFileContent;
import org.eclipse.n4js.utils.N4JSLanguageUtils;
import org.eclipse.xtext.build.IndexState;
import org.eclipse.xtext.build.Source2GeneratedMapping;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.impl.ResourceDescriptionsData;
import org.eclipse.xtext.resource.persistence.SerializableResourceDescription;
import org.eclipse.xtext.workspace.IProjectConfig;

public class ProjectStatePersister {
    private static final int VERSION_1 = 1;
    private static final int CURRENT_VERSION = 1;
    public static final String FILENAME = ".n4js.projectstate";

    public void writeProjectState(IProjectConfig project, IndexState state, Collection<? extends HashedFileContent> files) {
        try {
            File file = this.getDataFile(project);
            Throwable throwable = null;
            Object var6_8 = null;
            try (OutputStream nativeOut = Files.asByteSink((File)file, (FileWriteMode[])new FileWriteMode[0]).openBufferedStream();){
                this.writeProjectState(nativeOut, N4JSLanguageUtils.getLanguageVersion(), state, files);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public void writeProjectState(OutputStream stream, String languageVersion, IndexState state, Collection<? extends HashedFileContent> files) throws IOException {
        stream.write(1);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ObjectOutputStream output = new ObjectOutputStream(new BufferedOutputStream(new GZIPOutputStream(stream, 8192)));){
            output.writeUTF(languageVersion);
            output.writeInt(state.getResourceDescriptions().getAllURIs().size());
            for (IResourceDescription description : state.getResourceDescriptions().getAllResourceDescriptions()) {
                if (description instanceof SerializableResourceDescription) {
                    ((SerializableResourceDescription)description).writeExternal((ObjectOutput)output);
                    continue;
                }
                throw new IOException("Unexpected type: " + description.getClass().getName());
            }
            Source2GeneratedMapping fileMappings = state.getFileMappings();
            fileMappings.writeExternal((ObjectOutput)output);
            output.writeInt(files.size());
            for (HashedFileContent hashedFileContent : files) {
                hashedFileContent.write(output);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void readProjectState(IProjectConfig project, BiConsumer<? super IndexState, ? super Collection<? extends HashedFileContent>> result) {
        block11: {
            try {
                File file = this.getDataFile(project);
                if (!file.isFile()) break block11;
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream nativeIn = Files.asByteSource((File)file).openBufferedStream();){
                    this.readProjectState(nativeIn, N4JSLanguageUtils.getLanguageVersion(), result);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException | ClassNotFoundException | URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    public void readProjectState(InputStream stream, String expectedLanguageVersion, BiConsumer<? super IndexState, ? super Collection<? extends HashedFileContent>> result) throws IOException, ClassNotFoundException {
        int version = stream.read();
        if (version == 1) {
            Throwable throwable = null;
            Object var6_7 = null;
            try (ObjectInputStream input = new ObjectInputStream(new BufferedInputStream(new GZIPInputStream(stream, 8192)));){
                String languageVersion = input.readUTF();
                if (expectedLanguageVersion.equals(languageVersion)) {
                    ArrayList<SerializableResourceDescription> descriptions = new ArrayList<SerializableResourceDescription>();
                    int size = input.readInt();
                    while (size > 0) {
                        --size;
                        SerializableResourceDescription description = new SerializableResourceDescription();
                        description.readExternal((ObjectInput)input);
                        descriptions.add(description);
                    }
                    ResourceDescriptionsData resourceDescriptionsData = new ResourceDescriptionsData(descriptions);
                    Source2GeneratedMapping fileMappings = new Source2GeneratedMapping();
                    fileMappings.readExternal((ObjectInput)input);
                    HashSet<HashedFileContent> fingerprints = new HashSet<HashedFileContent>();
                    size = input.readInt();
                    while (size > 0) {
                        --size;
                        fingerprints.add(new HashedFileContent(input));
                    }
                    result.accept((IndexState)new IndexState(resourceDescriptionsData, fileMappings), fingerprints);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    private File getDataFile(IProjectConfig project) throws URISyntaxException {
        URI fileName = this.getFileName(project);
        File file = new File(new java.net.URI(fileName.toString()));
        return file;
    }

    private URI getFileName(IProjectConfig project) {
        URI rootPath = project.getPath();
        URI fileName = rootPath.appendSegment(FILENAME);
        return fileName;
    }
}

