/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.mwe.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.monitor.NullProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.internal.core.Workflow;
import org.eclipse.emf.mwe.internal.core.ast.util.WorkflowFactory;

public class WorkflowFacade {
    protected final Workflow workflow;
    protected final Issues issues = new IssuesImpl();

    public Issues getIssues() {
        return this.issues;
    }

    public WorkflowFacade(String path, Map<String, String> params) {
        WorkflowFactory factory = new WorkflowFactory();
        this.workflow = factory.parseInitAndCreate(path, params == null ? Collections.emptyMap() : params, WorkflowFactory.getDefaultConverter(), this.issues);
        if (this.workflow == null) {
            throw new IllegalStateException("Couldn't load workflow file from '" + path + "'. Problems: " + this.issues.toString());
        }
    }

    public WorkflowFacade(String string) {
        this(string, Collections.emptyMap());
    }

    public Issues check() {
        this.workflow.checkConfiguration(this.issues);
        return this.issues;
    }

    public Issues run() {
        Issues issues2 = this.check();
        if (issues2.hasErrors()) {
            throw new IllegalStateException(issues2.toString());
        }
        return this.run(new HashMap<String, Object>());
    }

    public Issues run(Map<String, Object> slotContents) {
        return this.run(slotContents, new NullProgressMonitor());
    }

    public Issues run(final Map<String, Object> slotContents, ProgressMonitor monitor) {
        WorkflowContext ctx = new WorkflowContext(){

            @Override
            public Object get(String slotName) {
                return slotContents.get(slotName);
            }

            @Override
            public String[] getSlotNames() {
                return slotContents.keySet().toArray(new String[0]);
            }

            @Override
            public void set(String slotName, Object value) {
                slotContents.put(slotName, value);
            }
        };
        this.workflow.invoke(ctx, new NullProgressMonitor(), this.issues);
        return this.issues;
    }
}

