/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ts.findReferences;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TEnumLiteral;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.findReferences.TargetURIs;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.SimpleAttributeResolver;

public class TargetURIKey {
    public static final TargetURIs.Key<Data> KEY = TargetURIs.Key.from((String)"org.eclipse.n4js.ts.findReferences.TargetURIKey", Data.class);
    @Inject
    private IQualifiedNameProvider qualifiedNameProvider;

    public Data getData(TargetURIs targetURIs, IReferenceFinder.IResourceAccess resourceAccess) {
        Data result = (Data)targetURIs.getUserData(KEY);
        if (result != null) {
            return result;
        }
        return this.initData(targetURIs, resourceAccess);
    }

    private Data initData(TargetURIs targetURIs, IReferenceFinder.IResourceAccess resourceAccess) {
        Data result = new Data(this.qualifiedNameProvider);
        this.init(result, resourceAccess, targetURIs);
        targetURIs.putUserData(KEY, (Object)result);
        return result;
    }

    private void init(Data result, IReferenceFinder.IResourceAccess resourceAccess, TargetURIs targetURIs) {
        targetURIs.getTargetResourceURIs().forEach(resourceURI -> resourceAccess.readOnly(resourceURI, resourceSet -> {
            targetURIs.getEObjectURIs(resourceURI).forEach(objectURI -> {
                try {
                    EObject object = resourceSet.getEObject(objectURI, true);
                    if (object != null) {
                        result.add(object);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            });
            return null;
        }));
    }

    public void setQualifiedNameProvider(IQualifiedNameProvider qualifiedNameProvider) {
        this.qualifiedNameProvider = qualifiedNameProvider;
    }

    public static class Data {
        private final Set<String> valueStrings;
        private final Set<EClass> applicableTypes;
        private final SortedSet<QualifiedName> typesOrModulesToFind;
        private final IQualifiedNameProvider qualifiedNameProvider;

        public Data(IQualifiedNameProvider qualifiedNameProvider) {
            this.qualifiedNameProvider = qualifiedNameProvider;
            this.valueStrings = Sets.newHashSet();
            this.applicableTypes = Sets.newHashSet();
            this.typesOrModulesToFind = Sets.newTreeSet();
        }

        public void add(EObject object) {
            this.applicableTypes.add(object.eClass());
            this.valueStrings.add((String)SimpleAttributeResolver.NAME_RESOLVER.apply(object));
            if (object instanceof TMember && ((TMember)object).isComposed()) {
                EList constituentMembers = ((TMember)object).getConstituentMembers();
                for (TMember constituentMember : constituentMembers) {
                    this.addFQNs((EObject)constituentMember);
                }
            } else {
                this.addFQNs(object);
            }
        }

        private void addFQNs(EObject object) {
            TModule containingModule;
            QualifiedName fullyQualifiedName;
            if (object instanceof TMember || object instanceof TEnumLiteral) {
                Type t = (Type)EcoreUtil2.getContainerOfType((EObject)object.eContainer(), Type.class);
                this.typesOrModulesToFind.add(this.qualifiedNameProvider.getFullyQualifiedName((EObject)t));
            } else if (object instanceof Type) {
                this.typesOrModulesToFind.add(this.qualifiedNameProvider.getFullyQualifiedName(object));
            } else if (object instanceof TModule) {
                this.typesOrModulesToFind.add(this.qualifiedNameProvider.getFullyQualifiedName(object));
            }
            if (object instanceof IdentifiableElement && (fullyQualifiedName = this.qualifiedNameProvider.getFullyQualifiedName((EObject)(containingModule = ((IdentifiableElement)object).getContainingModule()))) != null) {
                this.typesOrModulesToFind.add(fullyQualifiedName);
            }
        }

        public boolean isEReferenceTypeApplicable(EClass eReferenceType) {
            if (this.applicableTypes.isEmpty()) {
                return true;
            }
            for (EClass applicableType : this.applicableTypes) {
                if (!EcoreUtil2.isAssignableFrom((EClass)eReferenceType, (EClass)applicableType)) continue;
                return true;
            }
            return false;
        }

        public Set<QualifiedName> getTypesOrModulesToFind() {
            return this.typesOrModulesToFind;
        }

        public boolean isMatchingConcreteSyntax(String valueString) {
            if (this.valueStrings.isEmpty() || this.valueStrings.contains(valueString)) {
                return true;
            }
            int idx = valueString.lastIndexOf(46);
            return idx > 0 && this.valueStrings.contains(valueString.substring(idx + 1));
        }
    }
}

