/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.n4js.ui.labeling.helper;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import org.eclipse.n4js.n4JS.ExportedVariableStatement;
import org.eclipse.n4js.n4JS.ImportDeclaration;
import org.eclipse.n4js.n4JS.N4ClassifierDeclaration;
import org.eclipse.n4js.n4JS.N4GetterDeclaration;
import org.eclipse.n4js.n4JS.N4MemberDeclaration;
import org.eclipse.n4js.n4JS.N4SetterDeclaration;
import org.eclipse.n4js.n4JS.NamedElement;
import org.eclipse.n4js.n4JS.NamedImportSpecifier;
import org.eclipse.n4js.n4JS.NamespaceImportSpecifier;
import org.eclipse.n4js.n4JS.Script;
import org.eclipse.n4js.ts.types.IdentifiableElement;
import org.eclipse.n4js.ts.types.TClassifier;
import org.eclipse.n4js.ts.types.TExportableElement;
import org.eclipse.n4js.ts.types.TGetter;
import org.eclipse.n4js.ts.types.TMember;
import org.eclipse.n4js.ts.types.TModule;
import org.eclipse.n4js.ts.types.TSetter;
import org.eclipse.n4js.ts.types.Type;
import org.eclipse.n4js.ui.labeling.EObjectWithContext;
import org.eclipse.n4js.ui.typesearch.TypeSearchKind;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class LabelCalculationHelper {
    protected String _dispatchDoGetText(Void _null) {
        return "*null*";
    }

    protected String _dispatchDoGetText(EObjectWithContext objectWithContext) {
        String label = this.dispatchDoGetText(objectWithContext.obj);
        TMember _xifexpression = null;
        if (objectWithContext.obj instanceof N4MemberDeclaration) {
            _xifexpression = ((N4MemberDeclaration)objectWithContext.obj).getDefinedTypeElement();
        } else {
            TMember _xifexpression_1 = null;
            _xifexpression_1 = objectWithContext.obj instanceof TMember ? (TMember)objectWithContext.obj : null;
            _xifexpression = _xifexpression_1;
        }
        TMember member = _xifexpression;
        if (member != null && member.getContainingType() != null && !Objects.equal((Object)member.getContainingType(), (Object)objectWithContext.context)) {
            String _label = label;
            String _dispatchDoGetText = this.dispatchDoGetText(member.getContainingType());
            String _plus = " from " + _dispatchDoGetText;
            label = String.valueOf(_label) + _plus;
        }
        return label;
    }

    protected String _dispatchDoGetText(Script script) {
        return this.dispatchDoGetText(script.getModule());
    }

    protected String _dispatchDoGetText(ImportDeclaration importDelaration) {
        String _moduleSpecifier = this.getModuleSpecifier(importDelaration.getModule());
        String _plus = "imports from " + _moduleSpecifier;
        String _xifexpression = null;
        if (importDelaration.getImportSpecifiers().size() == 1 && !(IterableExtensions.head((Iterable)importDelaration.getImportSpecifiers()) instanceof NamespaceImportSpecifier)) {
            String _dispatchDoGetText = this.dispatchDoGetText(IterableExtensions.head((Iterable)importDelaration.getImportSpecifiers()));
            _xifexpression = ": " + _dispatchDoGetText;
        } else {
            _xifexpression = "";
        }
        return String.valueOf(_plus) + _xifexpression;
    }

    protected String _dispatchDoGetText(NamedImportSpecifier namedImportSpecifier) {
        boolean _tripleNotEquals;
        TExportableElement _importedElement = namedImportSpecifier.getImportedElement();
        String _name = null;
        if (_importedElement != null) {
            _name = _importedElement.getName();
        }
        String _xifexpression = null;
        String _alias = namedImportSpecifier.getAlias();
        boolean bl = _tripleNotEquals = _alias != null;
        if (_tripleNotEquals) {
            String _alias_1 = namedImportSpecifier.getAlias();
            _xifexpression = " as " + _alias_1;
        } else {
            _xifexpression = "";
        }
        return String.valueOf(_name) + _xifexpression;
    }

    protected String _dispatchDoGetText(N4ClassifierDeclaration it) {
        String _xifexpression = null;
        Type _definedType = it.getDefinedType();
        boolean _tripleEquals = _definedType == null;
        _xifexpression = _tripleEquals ? "<unknown>" : this.dispatchDoGetText(it.getDefinedType());
        return _xifexpression;
    }

    protected String _dispatchDoGetText(N4GetterDeclaration n4GetterDeclaration) {
        return this.dispatchDoGetText(n4GetterDeclaration.getDefinedGetter());
    }

    protected String _dispatchDoGetText(N4SetterDeclaration n4SetterDeclaration) {
        return this.dispatchDoGetText(n4SetterDeclaration.getDefinedSetter());
    }

    protected String _dispatchDoGetText(ExportedVariableStatement vs) {
        Functions.Function1 _function = it -> it.getName();
        return IterableExtensions.join((Iterable)ListExtensions.map((List)vs.getVarDecl(), (Functions.Function1)_function), (CharSequence)", ");
    }

    protected String _dispatchDoGetText(NamedElement namedElement) {
        return namedElement.getName();
    }

    protected String _dispatchDoGetText(TModule tModule) {
        return this.getModuleSpecifier(tModule);
    }

    protected String _dispatchDoGetText(TClassifier tClassifier) {
        String _name = tClassifier.getName();
        String _typeVersionDescription = this.getTypeVersionDescription(tClassifier);
        String _plus = String.valueOf(_name) + _typeVersionDescription;
        String _typeVarDescriptions = this.getTypeVarDescriptions(tClassifier);
        return String.valueOf(_plus) + _typeVarDescriptions;
    }

    private String getTypeVarDescriptions(TClassifier tClassifier) {
        boolean _greaterThan;
        String _xifexpression = null;
        int _size = tClassifier.getTypeVars().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            Functions.Function1 _function = it -> it.getName();
            String _join = IterableExtensions.join((Iterable)ListExtensions.map((List)tClassifier.getTypeVars(), (Functions.Function1)_function), (CharSequence)", ");
            String _plus = "<" + _join;
            _xifexpression = String.valueOf(_plus) + ">";
        } else {
            _xifexpression = "";
        }
        return _xifexpression;
    }

    private String getTypeVersionDescription(TClassifier tClassifier) {
        boolean _notEquals;
        int _declaredVersion = tClassifier.getDeclaredVersion();
        boolean bl = _notEquals = _declaredVersion != 0;
        if (_notEquals) {
            String _string = Integer.toString(tClassifier.getDeclaredVersion());
            return "#" + _string;
        }
        return "";
    }

    protected String _dispatchDoGetText(TGetter tGetter) {
        return tGetter.getName();
    }

    protected String _dispatchDoGetText(TSetter tSetter) {
        return tSetter.getName();
    }

    protected String _dispatchDoGetText(IdentifiableElement identifiableElement) {
        return identifiableElement.getName();
    }

    protected String _dispatchDoGetText(IEObjectDescription d) {
        boolean _matches = TypeSearchKind.EVERYTHING.matches(d.getEClass());
        if (_matches) {
            return d.getQualifiedName().getLastSegment();
        }
        return "<unknown>";
    }

    protected String _dispatchDoGetText(Object object) {
        return "<unknown>";
    }

    private String getModuleSpecifier(TModule tModule) {
        String _xifexpression = null;
        String _qualifiedName = null;
        if (tModule != null) {
            _qualifiedName = tModule.getQualifiedName();
        }
        boolean _tripleNotEquals = _qualifiedName != null;
        _xifexpression = _tripleNotEquals ? tModule.getModuleSpecifier() : "<unknown>";
        return _xifexpression;
    }

    public String dispatchDoGetText(Object tClassifier) {
        if (tClassifier instanceof TClassifier) {
            return this._dispatchDoGetText((TClassifier)tClassifier);
        }
        if (tClassifier instanceof TGetter) {
            return this._dispatchDoGetText((TGetter)tClassifier);
        }
        if (tClassifier instanceof TSetter) {
            return this._dispatchDoGetText((TSetter)tClassifier);
        }
        if (tClassifier instanceof N4ClassifierDeclaration) {
            return this._dispatchDoGetText((N4ClassifierDeclaration)tClassifier);
        }
        if (tClassifier instanceof N4GetterDeclaration) {
            return this._dispatchDoGetText((N4GetterDeclaration)tClassifier);
        }
        if (tClassifier instanceof N4SetterDeclaration) {
            return this._dispatchDoGetText((N4SetterDeclaration)tClassifier);
        }
        if (tClassifier instanceof ExportedVariableStatement) {
            return this._dispatchDoGetText((ExportedVariableStatement)tClassifier);
        }
        if (tClassifier instanceof ImportDeclaration) {
            return this._dispatchDoGetText((ImportDeclaration)tClassifier);
        }
        if (tClassifier instanceof NamedImportSpecifier) {
            return this._dispatchDoGetText((NamedImportSpecifier)tClassifier);
        }
        if (tClassifier instanceof Script) {
            return this._dispatchDoGetText((Script)tClassifier);
        }
        if (tClassifier instanceof IdentifiableElement) {
            return this._dispatchDoGetText((IdentifiableElement)tClassifier);
        }
        if (tClassifier instanceof TModule) {
            return this._dispatchDoGetText((TModule)tClassifier);
        }
        if (tClassifier instanceof NamedElement) {
            return this._dispatchDoGetText((NamedElement)tClassifier);
        }
        if (tClassifier == null) {
            return this._dispatchDoGetText((Void)null);
        }
        if (tClassifier instanceof EObjectWithContext) {
            return this._dispatchDoGetText((EObjectWithContext)tClassifier);
        }
        if (tClassifier instanceof IEObjectDescription) {
            return this._dispatchDoGetText((IEObjectDescription)tClassifier);
        }
        if (tClassifier != null) {
            return this._dispatchDoGetText(tClassifier);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(tClassifier).toString());
    }
}

